/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.transcribe.model.UpdateVocabularyFilterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class UpdateVocabularyFilterRequestMarshaller
implements Marshaller<Request<UpdateVocabularyFilterRequest>, UpdateVocabularyFilterRequest> {
    public Request<UpdateVocabularyFilterRequest> marshall(UpdateVocabularyFilterRequest updateVocabularyFilterRequest) {
        if (updateVocabularyFilterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateVocabularyFilterRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateVocabularyFilterRequest, "AmazonTranscribe");
        String target = "Transcribe.UpdateVocabularyFilter";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateVocabularyFilterRequest.getVocabularyFilterName() != null) {
                String vocabularyFilterName = updateVocabularyFilterRequest.getVocabularyFilterName();
                jsonWriter.name("VocabularyFilterName");
                jsonWriter.value(vocabularyFilterName);
            }
            if (updateVocabularyFilterRequest.getWords() != null) {
                List<String> words = updateVocabularyFilterRequest.getWords();
                jsonWriter.name("Words");
                jsonWriter.beginArray();
                for (String wordsItem : words) {
                    if (wordsItem == null) continue;
                    jsonWriter.value(wordsItem);
                }
                jsonWriter.endArray();
            }
            if (updateVocabularyFilterRequest.getVocabularyFilterFileUri() != null) {
                String vocabularyFilterFileUri = updateVocabularyFilterRequest.getVocabularyFilterFileUri();
                jsonWriter.name("VocabularyFilterFileUri");
                jsonWriter.value(vocabularyFilterFileUri);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

