/*
 * Copyright 2010-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.services.transcribe.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;
import com.amazonaws.util.json.AwsJsonReader;

/**
 * JSON unmarshaller for POJO TranscriptionJobSummary
 */
class TranscriptionJobSummaryJsonUnmarshaller implements
        Unmarshaller<TranscriptionJobSummary, JsonUnmarshallerContext> {

    public TranscriptionJobSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        TranscriptionJobSummary transcriptionJobSummary = new TranscriptionJobSummary();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("TranscriptionJobName")) {
                transcriptionJobSummary.setTranscriptionJobName(StringJsonUnmarshaller
                        .getInstance()
                        .unmarshall(context));
            } else if (name.equals("CreationTime")) {
                transcriptionJobSummary.setCreationTime(DateJsonUnmarshaller.getInstance()
                        .unmarshall(context));
            } else if (name.equals("StartTime")) {
                transcriptionJobSummary.setStartTime(DateJsonUnmarshaller.getInstance()
                        .unmarshall(context));
            } else if (name.equals("CompletionTime")) {
                transcriptionJobSummary.setCompletionTime(DateJsonUnmarshaller.getInstance()
                        .unmarshall(context));
            } else if (name.equals("LanguageCode")) {
                transcriptionJobSummary.setLanguageCode(StringJsonUnmarshaller.getInstance()
                        .unmarshall(context));
            } else if (name.equals("TranscriptionJobStatus")) {
                transcriptionJobSummary.setTranscriptionJobStatus(StringJsonUnmarshaller
                        .getInstance()
                        .unmarshall(context));
            } else if (name.equals("FailureReason")) {
                transcriptionJobSummary.setFailureReason(StringJsonUnmarshaller.getInstance()
                        .unmarshall(context));
            } else if (name.equals("OutputLocationType")) {
                transcriptionJobSummary.setOutputLocationType(StringJsonUnmarshaller.getInstance()
                        .unmarshall(context));
            } else if (name.equals("ContentRedaction")) {
                transcriptionJobSummary.setContentRedaction(ContentRedactionJsonUnmarshaller
                        .getInstance()
                        .unmarshall(context));
            } else if (name.equals("ModelSettings")) {
                transcriptionJobSummary.setModelSettings(ModelSettingsJsonUnmarshaller
                        .getInstance()
                        .unmarshall(context));
            } else if (name.equals("IdentifyLanguage")) {
                transcriptionJobSummary.setIdentifyLanguage(BooleanJsonUnmarshaller.getInstance()
                        .unmarshall(context));
            } else if (name.equals("IdentifiedLanguageScore")) {
                transcriptionJobSummary.setIdentifiedLanguageScore(FloatJsonUnmarshaller
                        .getInstance()
                        .unmarshall(context));
            } else {
                reader.skipValue();
            }
        }
        reader.endObject();
        return transcriptionJobSummary;
    }

    private static TranscriptionJobSummaryJsonUnmarshaller instance;

    public static TranscriptionJobSummaryJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new TranscriptionJobSummaryJsonUnmarshaller();
        return instance;
    }
}
