/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.services.transcribe.model.Media;
import com.amazonaws.services.transcribe.model.Settings;
import com.amazonaws.services.transcribe.model.Transcript;
import com.amazonaws.services.transcribe.model.TranscriptionJob;
import com.amazonaws.services.transcribe.model.transform.MediaJsonMarshaller;
import com.amazonaws.services.transcribe.model.transform.SettingsJsonMarshaller;
import com.amazonaws.services.transcribe.model.transform.TranscriptJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;

class TranscriptionJobJsonMarshaller {
    private static TranscriptionJobJsonMarshaller instance;

    TranscriptionJobJsonMarshaller() {
    }

    public void marshall(TranscriptionJob transcriptionJob, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (transcriptionJob.getTranscriptionJobName() != null) {
            String transcriptionJobName = transcriptionJob.getTranscriptionJobName();
            jsonWriter.name("TranscriptionJobName");
            jsonWriter.value(transcriptionJobName);
        }
        if (transcriptionJob.getTranscriptionJobStatus() != null) {
            String transcriptionJobStatus = transcriptionJob.getTranscriptionJobStatus();
            jsonWriter.name("TranscriptionJobStatus");
            jsonWriter.value(transcriptionJobStatus);
        }
        if (transcriptionJob.getLanguageCode() != null) {
            String languageCode = transcriptionJob.getLanguageCode();
            jsonWriter.name("LanguageCode");
            jsonWriter.value(languageCode);
        }
        if (transcriptionJob.getMediaSampleRateHertz() != null) {
            Integer mediaSampleRateHertz = transcriptionJob.getMediaSampleRateHertz();
            jsonWriter.name("MediaSampleRateHertz");
            jsonWriter.value((Number)mediaSampleRateHertz);
        }
        if (transcriptionJob.getMediaFormat() != null) {
            String mediaFormat = transcriptionJob.getMediaFormat();
            jsonWriter.name("MediaFormat");
            jsonWriter.value(mediaFormat);
        }
        if (transcriptionJob.getMedia() != null) {
            Media media = transcriptionJob.getMedia();
            jsonWriter.name("Media");
            MediaJsonMarshaller.getInstance().marshall(media, jsonWriter);
        }
        if (transcriptionJob.getTranscript() != null) {
            Transcript transcript = transcriptionJob.getTranscript();
            jsonWriter.name("Transcript");
            TranscriptJsonMarshaller.getInstance().marshall(transcript, jsonWriter);
        }
        if (transcriptionJob.getCreationTime() != null) {
            Date creationTime = transcriptionJob.getCreationTime();
            jsonWriter.name("CreationTime");
            jsonWriter.value(creationTime);
        }
        if (transcriptionJob.getCompletionTime() != null) {
            Date completionTime = transcriptionJob.getCompletionTime();
            jsonWriter.name("CompletionTime");
            jsonWriter.value(completionTime);
        }
        if (transcriptionJob.getFailureReason() != null) {
            String failureReason = transcriptionJob.getFailureReason();
            jsonWriter.name("FailureReason");
            jsonWriter.value(failureReason);
        }
        if (transcriptionJob.getSettings() != null) {
            Settings settings = transcriptionJob.getSettings();
            jsonWriter.name("Settings");
            SettingsJsonMarshaller.getInstance().marshall(settings, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static TranscriptionJobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TranscriptionJobJsonMarshaller();
        }
        return instance;
    }
}

