/*
 * Copyright 2010-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.transcribe.model;

import java.io.Serializable;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Provides a list of Call Analytics categories, including all rules that make
 * up each category.
 * </p>
 * <p>
 * To get detailed information about a specific Call Analytics category, use the
 * operation.
 * </p>
 */
public class ListCallAnalyticsCategoriesRequest extends AmazonWebServiceRequest implements
        Serializable {
    /**
     * <p>
     * If your <code>ListCallAnalyticsCategories</code> request returns more
     * results than can be displayed, <code>NextToken</code> is displayed in the
     * response with an associated string. To get the next page of results, copy
     * this string and repeat your request, including <code>NextToken</code>
     * with the value of the copied string. Repeat as needed to view all your
     * results.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b> - 8192<br/>
     * <b>Pattern: </b>.+<br/>
     */
    private String nextToken;

    /**
     * <p>
     * The maximum number of Call Analytics categories to return in each page of
     * results. If there are fewer results than the value that you specify, only
     * the actual results are returned. If you don't specify a value, a default
     * of 5 is used.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Range: </b>1 - 100<br/>
     */
    private Integer maxResults;

    /**
     * <p>
     * If your <code>ListCallAnalyticsCategories</code> request returns more
     * results than can be displayed, <code>NextToken</code> is displayed in the
     * response with an associated string. To get the next page of results, copy
     * this string and repeat your request, including <code>NextToken</code>
     * with the value of the copied string. Repeat as needed to view all your
     * results.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b> - 8192<br/>
     * <b>Pattern: </b>.+<br/>
     *
     * @return <p>
     *         If your <code>ListCallAnalyticsCategories</code> request returns
     *         more results than can be displayed, <code>NextToken</code> is
     *         displayed in the response with an associated string. To get the
     *         next page of results, copy this string and repeat your request,
     *         including <code>NextToken</code> with the value of the copied
     *         string. Repeat as needed to view all your results.
     *         </p>
     */
    public String getNextToken() {
        return nextToken;
    }

    /**
     * <p>
     * If your <code>ListCallAnalyticsCategories</code> request returns more
     * results than can be displayed, <code>NextToken</code> is displayed in the
     * response with an associated string. To get the next page of results, copy
     * this string and repeat your request, including <code>NextToken</code>
     * with the value of the copied string. Repeat as needed to view all your
     * results.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b> - 8192<br/>
     * <b>Pattern: </b>.+<br/>
     *
     * @param nextToken <p>
     *            If your <code>ListCallAnalyticsCategories</code> request
     *            returns more results than can be displayed,
     *            <code>NextToken</code> is displayed in the response with an
     *            associated string. To get the next page of results, copy this
     *            string and repeat your request, including
     *            <code>NextToken</code> with the value of the copied string.
     *            Repeat as needed to view all your results.
     *            </p>
     */
    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If your <code>ListCallAnalyticsCategories</code> request returns more
     * results than can be displayed, <code>NextToken</code> is displayed in the
     * response with an associated string. To get the next page of results, copy
     * this string and repeat your request, including <code>NextToken</code>
     * with the value of the copied string. Repeat as needed to view all your
     * results.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b> - 8192<br/>
     * <b>Pattern: </b>.+<br/>
     *
     * @param nextToken <p>
     *            If your <code>ListCallAnalyticsCategories</code> request
     *            returns more results than can be displayed,
     *            <code>NextToken</code> is displayed in the response with an
     *            associated string. To get the next page of results, copy this
     *            string and repeat your request, including
     *            <code>NextToken</code> with the value of the copied string.
     *            Repeat as needed to view all your results.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListCallAnalyticsCategoriesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    /**
     * <p>
     * The maximum number of Call Analytics categories to return in each page of
     * results. If there are fewer results than the value that you specify, only
     * the actual results are returned. If you don't specify a value, a default
     * of 5 is used.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Range: </b>1 - 100<br/>
     *
     * @return <p>
     *         The maximum number of Call Analytics categories to return in each
     *         page of results. If there are fewer results than the value that
     *         you specify, only the actual results are returned. If you don't
     *         specify a value, a default of 5 is used.
     *         </p>
     */
    public Integer getMaxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The maximum number of Call Analytics categories to return in each page of
     * results. If there are fewer results than the value that you specify, only
     * the actual results are returned. If you don't specify a value, a default
     * of 5 is used.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Range: </b>1 - 100<br/>
     *
     * @param maxResults <p>
     *            The maximum number of Call Analytics categories to return in
     *            each page of results. If there are fewer results than the
     *            value that you specify, only the actual results are returned.
     *            If you don't specify a value, a default of 5 is used.
     *            </p>
     */
    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of Call Analytics categories to return in each page of
     * results. If there are fewer results than the value that you specify, only
     * the actual results are returned. If you don't specify a value, a default
     * of 5 is used.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Range: </b>1 - 100<br/>
     *
     * @param maxResults <p>
     *            The maximum number of Call Analytics categories to return in
     *            each page of results. If there are fewer results than the
     *            value that you specify, only the actual results are returned.
     *            If you don't specify a value, a default of 5 is used.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListCallAnalyticsCategoriesRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: " + getNextToken() + ",");
        if (getMaxResults() != null)
            sb.append("MaxResults: " + getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListCallAnalyticsCategoriesRequest == false)
            return false;
        ListCallAnalyticsCategoriesRequest other = (ListCallAnalyticsCategoriesRequest) obj;

        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null
                && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null
                && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }
}
