/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetTranscriptionJobRequestMarshaller
implements Marshaller<Request<GetTranscriptionJobRequest>, GetTranscriptionJobRequest> {
    public Request<GetTranscriptionJobRequest> marshall(GetTranscriptionJobRequest getTranscriptionJobRequest) {
        if (getTranscriptionJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetTranscriptionJobRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getTranscriptionJobRequest, "AmazonTranscribe");
        String target = "Transcribe.GetTranscriptionJob";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getTranscriptionJobRequest.getTranscriptionJobName() != null) {
                String transcriptionJobName = getTranscriptionJobRequest.getTranscriptionJobName();
                jsonWriter.name("TranscriptionJobName");
                jsonWriter.value(transcriptionJobName);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

