/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.transcribe.model.CreateVocabularyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateVocabularyRequestMarshaller
implements Marshaller<Request<CreateVocabularyRequest>, CreateVocabularyRequest> {
    public Request<CreateVocabularyRequest> marshall(CreateVocabularyRequest createVocabularyRequest) {
        if (createVocabularyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateVocabularyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVocabularyRequest, "AmazonTranscribe");
        String target = "Transcribe.CreateVocabulary";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createVocabularyRequest.getVocabularyName() != null) {
                String vocabularyName = createVocabularyRequest.getVocabularyName();
                jsonWriter.name("VocabularyName");
                jsonWriter.value(vocabularyName);
            }
            if (createVocabularyRequest.getLanguageCode() != null) {
                String languageCode = createVocabularyRequest.getLanguageCode();
                jsonWriter.name("LanguageCode");
                jsonWriter.value(languageCode);
            }
            if (createVocabularyRequest.getPhrases() != null) {
                List<String> phrases = createVocabularyRequest.getPhrases();
                jsonWriter.name("Phrases");
                jsonWriter.beginArray();
                for (String phrasesItem : phrases) {
                    if (phrasesItem == null) continue;
                    jsonWriter.value(phrasesItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

