/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListTranscriptionJobsRequestMarshaller
implements Marshaller<Request<ListTranscriptionJobsRequest>, ListTranscriptionJobsRequest> {
    public Request<ListTranscriptionJobsRequest> marshall(ListTranscriptionJobsRequest listTranscriptionJobsRequest) {
        if (listTranscriptionJobsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListTranscriptionJobsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTranscriptionJobsRequest, "AmazonTranscribe");
        String target = "Transcribe.ListTranscriptionJobs";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (listTranscriptionJobsRequest.getStatus() != null) {
                String status = listTranscriptionJobsRequest.getStatus();
                jsonWriter.name("Status");
                jsonWriter.value(status);
            }
            if (listTranscriptionJobsRequest.getJobNameContains() != null) {
                String jobNameContains = listTranscriptionJobsRequest.getJobNameContains();
                jsonWriter.name("JobNameContains");
                jsonWriter.value(jobNameContains);
            }
            if (listTranscriptionJobsRequest.getNextToken() != null) {
                String nextToken = listTranscriptionJobsRequest.getNextToken();
                jsonWriter.name("NextToken");
                jsonWriter.value(nextToken);
            }
            if (listTranscriptionJobsRequest.getMaxResults() != null) {
                Integer maxResults = listTranscriptionJobsRequest.getMaxResults();
                jsonWriter.name("MaxResults");
                jsonWriter.value((Number)maxResults);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

