/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.services.transcribe.model.TranscriptionJobStatus;
import com.amazonaws.services.transcribe.model.VocabularyInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListVocabulariesResult
implements Serializable {
    private String status;
    private String nextToken;
    private List<VocabularyInfo> vocabularies;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ListVocabulariesResult withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(TranscriptionJobStatus status) {
        this.status = status.toString();
    }

    public ListVocabulariesResult withStatus(TranscriptionJobStatus status) {
        this.status = status.toString();
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListVocabulariesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public List<VocabularyInfo> getVocabularies() {
        return this.vocabularies;
    }

    public void setVocabularies(Collection<VocabularyInfo> vocabularies) {
        if (vocabularies == null) {
            this.vocabularies = null;
            return;
        }
        this.vocabularies = new ArrayList<VocabularyInfo>(vocabularies);
    }

    public ListVocabulariesResult withVocabularies(VocabularyInfo ... vocabularies) {
        if (this.getVocabularies() == null) {
            this.vocabularies = new ArrayList<VocabularyInfo>(vocabularies.length);
        }
        for (VocabularyInfo value : vocabularies) {
            this.vocabularies.add(value);
        }
        return this;
    }

    public ListVocabulariesResult withVocabularies(Collection<VocabularyInfo> vocabularies) {
        this.setVocabularies(vocabularies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getVocabularies() != null) {
            sb.append("Vocabularies: " + this.getVocabularies());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularies() == null ? 0 : this.getVocabularies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVocabulariesResult)) {
            return false;
        }
        ListVocabulariesResult other = (ListVocabulariesResult)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getVocabularies() == null ^ this.getVocabularies() == null) {
            return false;
        }
        return other.getVocabularies() == null || other.getVocabularies().equals(this.getVocabularies());
    }
}

