/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.translate.AmazonTranslateAsync;
import com.amazonaws.services.translate.AmazonTranslateClient;
import com.amazonaws.services.translate.model.DeleteTerminologyRequest;
import com.amazonaws.services.translate.model.GetTerminologyRequest;
import com.amazonaws.services.translate.model.GetTerminologyResult;
import com.amazonaws.services.translate.model.ImportTerminologyRequest;
import com.amazonaws.services.translate.model.ImportTerminologyResult;
import com.amazonaws.services.translate.model.ListTerminologiesRequest;
import com.amazonaws.services.translate.model.ListTerminologiesResult;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.services.translate.model.TranslateTextResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonTranslateAsyncClient
extends AmazonTranslateClient
implements AmazonTranslateAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;

    @Deprecated
    public AmazonTranslateAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    @Deprecated
    public AmazonTranslateAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonTranslateAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(10));
    }

    public AmazonTranslateAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonTranslateAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonTranslateAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(10));
    }

    public AmazonTranslateAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonTranslateAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonTranslateAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> deleteTerminologyAsync(final DeleteTerminologyRequest deleteTerminologyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonTranslateAsyncClient.this.deleteTerminology(deleteTerminologyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTerminologyAsync(final DeleteTerminologyRequest deleteTerminologyRequest, final AsyncHandler<DeleteTerminologyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonTranslateAsyncClient.this.deleteTerminology(deleteTerminologyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteTerminologyRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetTerminologyResult> getTerminologyAsync(final GetTerminologyRequest getTerminologyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTerminologyResult>(){

            @Override
            public GetTerminologyResult call() throws Exception {
                return AmazonTranslateAsyncClient.this.getTerminology(getTerminologyRequest);
            }
        });
    }

    @Override
    public Future<GetTerminologyResult> getTerminologyAsync(final GetTerminologyRequest getTerminologyRequest, final AsyncHandler<GetTerminologyRequest, GetTerminologyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTerminologyResult>(){

            @Override
            public GetTerminologyResult call() throws Exception {
                GetTerminologyResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.getTerminology(getTerminologyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getTerminologyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ImportTerminologyResult> importTerminologyAsync(final ImportTerminologyRequest importTerminologyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportTerminologyResult>(){

            @Override
            public ImportTerminologyResult call() throws Exception {
                return AmazonTranslateAsyncClient.this.importTerminology(importTerminologyRequest);
            }
        });
    }

    @Override
    public Future<ImportTerminologyResult> importTerminologyAsync(final ImportTerminologyRequest importTerminologyRequest, final AsyncHandler<ImportTerminologyRequest, ImportTerminologyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportTerminologyResult>(){

            @Override
            public ImportTerminologyResult call() throws Exception {
                ImportTerminologyResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.importTerminology(importTerminologyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)importTerminologyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTerminologiesResult> listTerminologiesAsync(final ListTerminologiesRequest listTerminologiesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTerminologiesResult>(){

            @Override
            public ListTerminologiesResult call() throws Exception {
                return AmazonTranslateAsyncClient.this.listTerminologies(listTerminologiesRequest);
            }
        });
    }

    @Override
    public Future<ListTerminologiesResult> listTerminologiesAsync(final ListTerminologiesRequest listTerminologiesRequest, final AsyncHandler<ListTerminologiesRequest, ListTerminologiesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTerminologiesResult>(){

            @Override
            public ListTerminologiesResult call() throws Exception {
                ListTerminologiesResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.listTerminologies(listTerminologiesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTerminologiesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<TranslateTextResult> translateTextAsync(final TranslateTextRequest translateTextRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TranslateTextResult>(){

            @Override
            public TranslateTextResult call() throws Exception {
                return AmazonTranslateAsyncClient.this.translateText(translateTextRequest);
            }
        });
    }

    @Override
    public Future<TranslateTextResult> translateTextAsync(final TranslateTextRequest translateTextRequest, final AsyncHandler<TranslateTextRequest, TranslateTextResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TranslateTextResult>(){

            @Override
            public TranslateTextResult call() throws Exception {
                TranslateTextResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.translateText(translateTextRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)translateTextRequest, (Object)result);
                return result;
            }
        });
    }
}

