/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.translate.model.GetTerminologyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetTerminologyRequestMarshaller
implements Marshaller<Request<GetTerminologyRequest>, GetTerminologyRequest> {
    public Request<GetTerminologyRequest> marshall(GetTerminologyRequest getTerminologyRequest) {
        if (getTerminologyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetTerminologyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getTerminologyRequest, "AmazonTranslate");
        String target = "AWSShineFrontendService_20170701.GetTerminology";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getTerminologyRequest.getName() != null) {
                String name = getTerminologyRequest.getName();
                jsonWriter.name("Name");
                jsonWriter.value(name);
            }
            if (getTerminologyRequest.getTerminologyDataFormat() != null) {
                String terminologyDataFormat = getTerminologyRequest.getTerminologyDataFormat();
                jsonWriter.name("TerminologyDataFormat");
                jsonWriter.value(terminologyDataFormat);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

