/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.translate.model.EncryptionKey;
import com.amazonaws.services.translate.model.ImportTerminologyRequest;
import com.amazonaws.services.translate.model.TerminologyData;
import com.amazonaws.services.translate.model.transform.EncryptionKeyJsonMarshaller;
import com.amazonaws.services.translate.model.transform.TerminologyDataJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ImportTerminologyRequestMarshaller
implements Marshaller<Request<ImportTerminologyRequest>, ImportTerminologyRequest> {
    public Request<ImportTerminologyRequest> marshall(ImportTerminologyRequest importTerminologyRequest) {
        if (importTerminologyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ImportTerminologyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importTerminologyRequest, "AmazonTranslate");
        String target = "AWSShineFrontendService_20170701.ImportTerminology";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (importTerminologyRequest.getName() != null) {
                String name = importTerminologyRequest.getName();
                jsonWriter.name("Name");
                jsonWriter.value(name);
            }
            if (importTerminologyRequest.getMergeStrategy() != null) {
                String mergeStrategy = importTerminologyRequest.getMergeStrategy();
                jsonWriter.name("MergeStrategy");
                jsonWriter.value(mergeStrategy);
            }
            if (importTerminologyRequest.getDescription() != null) {
                String description = importTerminologyRequest.getDescription();
                jsonWriter.name("Description");
                jsonWriter.value(description);
            }
            if (importTerminologyRequest.getTerminologyData() != null) {
                TerminologyData terminologyData = importTerminologyRequest.getTerminologyData();
                jsonWriter.name("TerminologyData");
                TerminologyDataJsonMarshaller.getInstance().marshall(terminologyData, jsonWriter);
            }
            if (importTerminologyRequest.getEncryptionKey() != null) {
                EncryptionKey encryptionKey = importTerminologyRequest.getEncryptionKey();
                jsonWriter.name("EncryptionKey");
                EncryptionKeyJsonMarshaller.getInstance().marshall(encryptionKey, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

