/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.services.translate.model.TerminologyData;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class TerminologyDataJsonUnmarshaller
implements Unmarshaller<TerminologyData, JsonUnmarshallerContext> {
    private static TerminologyDataJsonUnmarshaller instance;

    TerminologyDataJsonUnmarshaller() {
    }

    public TerminologyData unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        TerminologyData terminologyData = new TerminologyData();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("File")) {
                terminologyData.setFile(SimpleTypeJsonUnmarshallers.ByteBufferJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Format")) {
                terminologyData.setFormat(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return terminologyData;
    }

    public static TerminologyDataJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TerminologyDataJsonUnmarshaller();
        }
        return instance;
    }
}

