/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.services.translate.model.EncryptionKey;
import com.amazonaws.services.translate.model.TerminologyProperties;
import com.amazonaws.services.translate.model.transform.EncryptionKeyJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class TerminologyPropertiesJsonMarshaller {
    private static TerminologyPropertiesJsonMarshaller instance;

    TerminologyPropertiesJsonMarshaller() {
    }

    public void marshall(TerminologyProperties terminologyProperties, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (terminologyProperties.getName() != null) {
            String name = terminologyProperties.getName();
            jsonWriter.name("Name");
            jsonWriter.value(name);
        }
        if (terminologyProperties.getDescription() != null) {
            String description = terminologyProperties.getDescription();
            jsonWriter.name("Description");
            jsonWriter.value(description);
        }
        if (terminologyProperties.getArn() != null) {
            String arn = terminologyProperties.getArn();
            jsonWriter.name("Arn");
            jsonWriter.value(arn);
        }
        if (terminologyProperties.getSourceLanguageCode() != null) {
            String sourceLanguageCode = terminologyProperties.getSourceLanguageCode();
            jsonWriter.name("SourceLanguageCode");
            jsonWriter.value(sourceLanguageCode);
        }
        if (terminologyProperties.getTargetLanguageCodes() != null) {
            List<String> targetLanguageCodes = terminologyProperties.getTargetLanguageCodes();
            jsonWriter.name("TargetLanguageCodes");
            jsonWriter.beginArray();
            for (String targetLanguageCodesItem : targetLanguageCodes) {
                if (targetLanguageCodesItem == null) continue;
                jsonWriter.value(targetLanguageCodesItem);
            }
            jsonWriter.endArray();
        }
        if (terminologyProperties.getEncryptionKey() != null) {
            EncryptionKey encryptionKey = terminologyProperties.getEncryptionKey();
            jsonWriter.name("EncryptionKey");
            EncryptionKeyJsonMarshaller.getInstance().marshall(encryptionKey, jsonWriter);
        }
        if (terminologyProperties.getSizeBytes() != null) {
            Integer sizeBytes = terminologyProperties.getSizeBytes();
            jsonWriter.name("SizeBytes");
            jsonWriter.value((Number)sizeBytes);
        }
        if (terminologyProperties.getTermCount() != null) {
            Integer termCount = terminologyProperties.getTermCount();
            jsonWriter.name("TermCount");
            jsonWriter.value((Number)termCount);
        }
        if (terminologyProperties.getCreatedAt() != null) {
            Date createdAt = terminologyProperties.getCreatedAt();
            jsonWriter.name("CreatedAt");
            jsonWriter.value(createdAt);
        }
        if (terminologyProperties.getLastUpdatedAt() != null) {
            Date lastUpdatedAt = terminologyProperties.getLastUpdatedAt();
            jsonWriter.name("LastUpdatedAt");
            jsonWriter.value(lastUpdatedAt);
        }
        jsonWriter.endObject();
    }

    public static TerminologyPropertiesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TerminologyPropertiesJsonMarshaller();
        }
        return instance;
    }
}

