/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class TranslateTextRequestMarshaller
implements Marshaller<Request<TranslateTextRequest>, TranslateTextRequest> {
    public Request<TranslateTextRequest> marshall(TranslateTextRequest translateTextRequest) {
        if (translateTextRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(TranslateTextRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)translateTextRequest, "AmazonTranslate");
        String target = "AWSShineFrontendService_20170701.TranslateText";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (translateTextRequest.getText() != null) {
                String text = translateTextRequest.getText();
                jsonWriter.name("Text");
                jsonWriter.value(text);
            }
            if (translateTextRequest.getTerminologyNames() != null) {
                List<String> terminologyNames = translateTextRequest.getTerminologyNames();
                jsonWriter.name("TerminologyNames");
                jsonWriter.beginArray();
                for (String terminologyNamesItem : terminologyNames) {
                    if (terminologyNamesItem == null) continue;
                    jsonWriter.value(terminologyNamesItem);
                }
                jsonWriter.endArray();
            }
            if (translateTextRequest.getSourceLanguageCode() != null) {
                String sourceLanguageCode = translateTextRequest.getSourceLanguageCode();
                jsonWriter.name("SourceLanguageCode");
                jsonWriter.value(sourceLanguageCode);
            }
            if (translateTextRequest.getTargetLanguageCode() != null) {
                String targetLanguageCode = translateTextRequest.getTargetLanguageCode();
                jsonWriter.name("TargetLanguageCode");
                jsonWriter.value(targetLanguageCode);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

