/*
 * Copyright 2010-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.translate.model;

import java.io.Serializable;

public class ListTextTranslationJobsResult implements Serializable {
    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     */
    private java.util.List<TextTranslationJobProperties> textTranslationJobPropertiesList;

    /**
     * <p>
     * The token to use to retreive the next page of results. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b> - 8192<br/>
     * <b>Pattern: </b>\p{ASCII}{0,8192}<br/>
     */
    private String nextToken;

    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     *
     * @return <p>
     *         A list containing the properties of each job that is returned.
     *         </p>
     */
    public java.util.List<TextTranslationJobProperties> getTextTranslationJobPropertiesList() {
        return textTranslationJobPropertiesList;
    }

    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     *
     * @param textTranslationJobPropertiesList <p>
     *            A list containing the properties of each job that is returned.
     *            </p>
     */
    public void setTextTranslationJobPropertiesList(
            java.util.Collection<TextTranslationJobProperties> textTranslationJobPropertiesList) {
        if (textTranslationJobPropertiesList == null) {
            this.textTranslationJobPropertiesList = null;
            return;
        }

        this.textTranslationJobPropertiesList = new java.util.ArrayList<TextTranslationJobProperties>(
                textTranslationJobPropertiesList);
    }

    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param textTranslationJobPropertiesList <p>
     *            A list containing the properties of each job that is returned.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListTextTranslationJobsResult withTextTranslationJobPropertiesList(
            TextTranslationJobProperties... textTranslationJobPropertiesList) {
        if (getTextTranslationJobPropertiesList() == null) {
            this.textTranslationJobPropertiesList = new java.util.ArrayList<TextTranslationJobProperties>(
                    textTranslationJobPropertiesList.length);
        }
        for (TextTranslationJobProperties value : textTranslationJobPropertiesList) {
            this.textTranslationJobPropertiesList.add(value);
        }
        return this;
    }

    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param textTranslationJobPropertiesList <p>
     *            A list containing the properties of each job that is returned.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListTextTranslationJobsResult withTextTranslationJobPropertiesList(
            java.util.Collection<TextTranslationJobProperties> textTranslationJobPropertiesList) {
        setTextTranslationJobPropertiesList(textTranslationJobPropertiesList);
        return this;
    }

    /**
     * <p>
     * The token to use to retreive the next page of results. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b> - 8192<br/>
     * <b>Pattern: </b>\p{ASCII}{0,8192}<br/>
     *
     * @return <p>
     *         The token to use to retreive the next page of results. This value
     *         is <code>null</code> when there are no more results to return.
     *         </p>
     */
    public String getNextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The token to use to retreive the next page of results. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b> - 8192<br/>
     * <b>Pattern: </b>\p{ASCII}{0,8192}<br/>
     *
     * @param nextToken <p>
     *            The token to use to retreive the next page of results. This
     *            value is <code>null</code> when there are no more results to
     *            return.
     *            </p>
     */
    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use to retreive the next page of results. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b> - 8192<br/>
     * <b>Pattern: </b>\p{ASCII}{0,8192}<br/>
     *
     * @param nextToken <p>
     *            The token to use to retreive the next page of results. This
     *            value is <code>null</code> when there are no more results to
     *            return.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListTextTranslationJobsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTextTranslationJobPropertiesList() != null)
            sb.append("TextTranslationJobPropertiesList: " + getTextTranslationJobPropertiesList()
                    + ",");
        if (getNextToken() != null)
            sb.append("NextToken: " + getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getTextTranslationJobPropertiesList() == null) ? 0
                        : getTextTranslationJobPropertiesList().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListTextTranslationJobsResult == false)
            return false;
        ListTextTranslationJobsResult other = (ListTextTranslationJobsResult) obj;

        if (other.getTextTranslationJobPropertiesList() == null
                ^ this.getTextTranslationJobPropertiesList() == null)
            return false;
        if (other.getTextTranslationJobPropertiesList() != null
                && other.getTextTranslationJobPropertiesList().equals(
                        this.getTextTranslationJobPropertiesList()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null
                && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }
}
