/*
 * Copyright 2010-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.translate.model;

import java.io.Serializable;

public class StartTextTranslationJobResult implements Serializable {
    /**
     * <p>
     * The identifier generated for the job. To get the status of a job, use
     * this ID with the <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 32<br/>
     * <b>Pattern: </b>^([\p{L}\p{Z}\p{N}_.:/=+\-%@]*)$<br/>
     */
    private String jobId;

    /**
     * <p>
     * The status of the job. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUBMITTED</code> - The job has been received and is queued for
     * processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Amazon Translate is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The job was successfully completed and the
     * output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors.
     * The errors can be analyzed in the job's output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The job did not complete. To get details, use the
     * <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_REQUESTED</code> - The user who started the job has requested
     * that it be stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - The job has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>SUBMITTED, IN_PROGRESS, COMPLETED,
     * COMPLETED_WITH_ERROR, FAILED, STOP_REQUESTED, STOPPED
     */
    private String jobStatus;

    /**
     * <p>
     * The identifier generated for the job. To get the status of a job, use
     * this ID with the <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 32<br/>
     * <b>Pattern: </b>^([\p{L}\p{Z}\p{N}_.:/=+\-%@]*)$<br/>
     *
     * @return <p>
     *         The identifier generated for the job. To get the status of a job,
     *         use this ID with the <a>DescribeTextTranslationJob</a> operation.
     *         </p>
     */
    public String getJobId() {
        return jobId;
    }

    /**
     * <p>
     * The identifier generated for the job. To get the status of a job, use
     * this ID with the <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 32<br/>
     * <b>Pattern: </b>^([\p{L}\p{Z}\p{N}_.:/=+\-%@]*)$<br/>
     *
     * @param jobId <p>
     *            The identifier generated for the job. To get the status of a
     *            job, use this ID with the <a>DescribeTextTranslationJob</a>
     *            operation.
     *            </p>
     */
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    /**
     * <p>
     * The identifier generated for the job. To get the status of a job, use
     * this ID with the <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 32<br/>
     * <b>Pattern: </b>^([\p{L}\p{Z}\p{N}_.:/=+\-%@]*)$<br/>
     *
     * @param jobId <p>
     *            The identifier generated for the job. To get the status of a
     *            job, use this ID with the <a>DescribeTextTranslationJob</a>
     *            operation.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public StartTextTranslationJobResult withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    /**
     * <p>
     * The status of the job. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUBMITTED</code> - The job has been received and is queued for
     * processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Amazon Translate is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The job was successfully completed and the
     * output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors.
     * The errors can be analyzed in the job's output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The job did not complete. To get details, use the
     * <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_REQUESTED</code> - The user who started the job has requested
     * that it be stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - The job has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>SUBMITTED, IN_PROGRESS, COMPLETED,
     * COMPLETED_WITH_ERROR, FAILED, STOP_REQUESTED, STOPPED
     *
     * @return <p>
     *         The status of the job. Possible values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUBMITTED</code> - The job has been received and is queued
     *         for processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Amazon Translate is processing the
     *         job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The job was successfully completed and
     *         the output is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED_WITH_ERROR</code> - The job was completed with
     *         errors. The errors can be analyzed in the job's output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The job did not complete. To get details,
     *         use the <a>DescribeTextTranslationJob</a> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_REQUESTED</code> - The user who started the job has
     *         requested that it be stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> - The job has been stopped.
     *         </p>
     *         </li>
     *         </ul>
     * @see JobStatus
     */
    public String getJobStatus() {
        return jobStatus;
    }

    /**
     * <p>
     * The status of the job. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUBMITTED</code> - The job has been received and is queued for
     * processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Amazon Translate is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The job was successfully completed and the
     * output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors.
     * The errors can be analyzed in the job's output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The job did not complete. To get details, use the
     * <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_REQUESTED</code> - The user who started the job has requested
     * that it be stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - The job has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>SUBMITTED, IN_PROGRESS, COMPLETED,
     * COMPLETED_WITH_ERROR, FAILED, STOP_REQUESTED, STOPPED
     *
     * @param jobStatus <p>
     *            The status of the job. Possible values include:
     *            </p>
     *            <ul>
     *            <li>
     *            <p>
     *            <code>SUBMITTED</code> - The job has been received and is
     *            queued for processing.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>IN_PROGRESS</code> - Amazon Translate is processing the
     *            job.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>COMPLETED</code> - The job was successfully completed
     *            and the output is available.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>COMPLETED_WITH_ERROR</code> - The job was completed with
     *            errors. The errors can be analyzed in the job's output.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>FAILED</code> - The job did not complete. To get
     *            details, use the <a>DescribeTextTranslationJob</a> operation.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>STOP_REQUESTED</code> - The user who started the job has
     *            requested that it be stopped.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>STOPPED</code> - The job has been stopped.
     *            </p>
     *            </li>
     *            </ul>
     * @see JobStatus
     */
    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    /**
     * <p>
     * The status of the job. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUBMITTED</code> - The job has been received and is queued for
     * processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Amazon Translate is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The job was successfully completed and the
     * output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors.
     * The errors can be analyzed in the job's output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The job did not complete. To get details, use the
     * <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_REQUESTED</code> - The user who started the job has requested
     * that it be stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - The job has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>SUBMITTED, IN_PROGRESS, COMPLETED,
     * COMPLETED_WITH_ERROR, FAILED, STOP_REQUESTED, STOPPED
     *
     * @param jobStatus <p>
     *            The status of the job. Possible values include:
     *            </p>
     *            <ul>
     *            <li>
     *            <p>
     *            <code>SUBMITTED</code> - The job has been received and is
     *            queued for processing.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>IN_PROGRESS</code> - Amazon Translate is processing the
     *            job.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>COMPLETED</code> - The job was successfully completed
     *            and the output is available.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>COMPLETED_WITH_ERROR</code> - The job was completed with
     *            errors. The errors can be analyzed in the job's output.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>FAILED</code> - The job did not complete. To get
     *            details, use the <a>DescribeTextTranslationJob</a> operation.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>STOP_REQUESTED</code> - The user who started the job has
     *            requested that it be stopped.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>STOPPED</code> - The job has been stopped.
     *            </p>
     *            </li>
     *            </ul>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     * @see JobStatus
     */
    public StartTextTranslationJobResult withJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    /**
     * <p>
     * The status of the job. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUBMITTED</code> - The job has been received and is queued for
     * processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Amazon Translate is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The job was successfully completed and the
     * output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors.
     * The errors can be analyzed in the job's output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The job did not complete. To get details, use the
     * <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_REQUESTED</code> - The user who started the job has requested
     * that it be stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - The job has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>SUBMITTED, IN_PROGRESS, COMPLETED,
     * COMPLETED_WITH_ERROR, FAILED, STOP_REQUESTED, STOPPED
     *
     * @param jobStatus <p>
     *            The status of the job. Possible values include:
     *            </p>
     *            <ul>
     *            <li>
     *            <p>
     *            <code>SUBMITTED</code> - The job has been received and is
     *            queued for processing.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>IN_PROGRESS</code> - Amazon Translate is processing the
     *            job.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>COMPLETED</code> - The job was successfully completed
     *            and the output is available.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>COMPLETED_WITH_ERROR</code> - The job was completed with
     *            errors. The errors can be analyzed in the job's output.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>FAILED</code> - The job did not complete. To get
     *            details, use the <a>DescribeTextTranslationJob</a> operation.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>STOP_REQUESTED</code> - The user who started the job has
     *            requested that it be stopped.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>STOPPED</code> - The job has been stopped.
     *            </p>
     *            </li>
     *            </ul>
     * @see JobStatus
     */
    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
    }

    /**
     * <p>
     * The status of the job. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUBMITTED</code> - The job has been received and is queued for
     * processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Amazon Translate is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The job was successfully completed and the
     * output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors.
     * The errors can be analyzed in the job's output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The job did not complete. To get details, use the
     * <a>DescribeTextTranslationJob</a> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_REQUESTED</code> - The user who started the job has requested
     * that it be stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - The job has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>SUBMITTED, IN_PROGRESS, COMPLETED,
     * COMPLETED_WITH_ERROR, FAILED, STOP_REQUESTED, STOPPED
     *
     * @param jobStatus <p>
     *            The status of the job. Possible values include:
     *            </p>
     *            <ul>
     *            <li>
     *            <p>
     *            <code>SUBMITTED</code> - The job has been received and is
     *            queued for processing.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>IN_PROGRESS</code> - Amazon Translate is processing the
     *            job.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>COMPLETED</code> - The job was successfully completed
     *            and the output is available.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>COMPLETED_WITH_ERROR</code> - The job was completed with
     *            errors. The errors can be analyzed in the job's output.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>FAILED</code> - The job did not complete. To get
     *            details, use the <a>DescribeTextTranslationJob</a> operation.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>STOP_REQUESTED</code> - The user who started the job has
     *            requested that it be stopped.
     *            </p>
     *            </li>
     *            <li>
     *            <p>
     *            <code>STOPPED</code> - The job has been stopped.
     *            </p>
     *            </li>
     *            </ul>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     * @see JobStatus
     */
    public StartTextTranslationJobResult withJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getJobId() != null)
            sb.append("JobId: " + getJobId() + ",");
        if (getJobStatus() != null)
            sb.append("JobStatus: " + getJobStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getJobId() == null) ? 0 : getJobId().hashCode());
        hashCode = prime * hashCode + ((getJobStatus() == null) ? 0 : getJobStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartTextTranslationJobResult == false)
            return false;
        StartTextTranslationJobResult other = (StartTextTranslationJobResult) obj;

        if (other.getJobId() == null ^ this.getJobId() == null)
            return false;
        if (other.getJobId() != null && other.getJobId().equals(this.getJobId()) == false)
            return false;
        if (other.getJobStatus() == null ^ this.getJobStatus() == null)
            return false;
        if (other.getJobStatus() != null
                && other.getJobStatus().equals(this.getJobStatus()) == false)
            return false;
        return true;
    }
}
