/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.ThrottlingInvoker;
import com.amazonaws.athena.connector.lambda.handlers.AthenaExceptionFilter;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.amazonaws.services.athena.model.InvalidRequestException;
import com.amazonaws.services.athena.model.QueryExecution;
import com.amazonaws.services.athena.model.QueryExecutionStatus;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class QueryStatusCheckerTest {
    private final ThrottlingInvoker athenaInvoker = ThrottlingInvoker.newDefaultBuilder((ThrottlingInvoker.ExceptionFilter)AthenaExceptionFilter.ATHENA_EXCEPTION_FILTER).build();
    @Mock
    private AmazonAthena athena;

    @Test
    public void testFastTermination() throws InterruptedException {
        String queryId = "query0";
        GetQueryExecutionRequest request = new GetQueryExecutionRequest().withQueryExecutionId(queryId);
        Mockito.when((Object)this.athena.getQueryExecution(request)).thenReturn((Object)new GetQueryExecutionResult().withQueryExecution(new QueryExecution().withStatus(new QueryExecutionStatus().withState("FAILED"))));
        QueryStatusChecker queryStatusChecker = new QueryStatusChecker(this.athena, this.athenaInvoker, queryId);
        Assert.assertTrue((boolean)queryStatusChecker.isQueryRunning());
        Thread.sleep(2000L);
        Assert.assertFalse((boolean)queryStatusChecker.isQueryRunning());
        ((AmazonAthena)Mockito.verify((Object)this.athena, (VerificationMode)Mockito.times((int)1))).getQueryExecution((GetQueryExecutionRequest)Matchers.any());
    }

    @Test
    public void testSlowTermination() throws InterruptedException {
        String queryId = "query1";
        GetQueryExecutionRequest request = new GetQueryExecutionRequest().withQueryExecutionId(queryId);
        GetQueryExecutionResult result1and2 = new GetQueryExecutionResult().withQueryExecution(new QueryExecution().withStatus(new QueryExecutionStatus().withState("RUNNING")));
        GetQueryExecutionResult result3 = new GetQueryExecutionResult().withQueryExecution(new QueryExecution().withStatus(new QueryExecutionStatus().withState("SUCCEEDED")));
        Mockito.when((Object)this.athena.getQueryExecution(request)).thenReturn((Object)result1and2).thenReturn((Object)result1and2).thenReturn((Object)result3);
        try (QueryStatusChecker queryStatusChecker = new QueryStatusChecker(this.athena, this.athenaInvoker, queryId);){
            Assert.assertTrue((boolean)queryStatusChecker.isQueryRunning());
            Thread.sleep(2000L);
            Assert.assertTrue((boolean)queryStatusChecker.isQueryRunning());
            Thread.sleep(3000L);
            Assert.assertFalse((boolean)queryStatusChecker.isQueryRunning());
            ((AmazonAthena)Mockito.verify((Object)this.athena, (VerificationMode)Mockito.times((int)3))).getQueryExecution((GetQueryExecutionRequest)Matchers.any());
        }
    }

    @Test
    public void testNotFound() throws InterruptedException {
        String queryId = "query2";
        GetQueryExecutionRequest request = new GetQueryExecutionRequest().withQueryExecutionId(queryId);
        Mockito.when((Object)this.athena.getQueryExecution(request)).thenThrow(new Throwable[]{new InvalidRequestException("")});
        try (QueryStatusChecker queryStatusChecker = new QueryStatusChecker(this.athena, this.athenaInvoker, queryId);){
            Assert.assertTrue((boolean)queryStatusChecker.isQueryRunning());
            Thread.sleep(2000L);
            Assert.assertTrue((boolean)queryStatusChecker.isQueryRunning());
            ((AmazonAthena)Mockito.verify((Object)this.athena, (VerificationMode)Mockito.times((int)1))).getQueryExecution((GetQueryExecutionRequest)Matchers.any());
        }
    }

    @Test
    public void testOtherError() throws InterruptedException {
        String queryId = "query3";
        GetQueryExecutionRequest request = new GetQueryExecutionRequest().withQueryExecutionId(queryId);
        Mockito.when((Object)this.athena.getQueryExecution(request)).thenThrow(new Throwable[]{new AmazonServiceException("")});
        try (QueryStatusChecker queryStatusChecker = new QueryStatusChecker(this.athena, this.athenaInvoker, queryId);){
            Assert.assertTrue((boolean)queryStatusChecker.isQueryRunning());
            Thread.sleep(3000L);
            Assert.assertTrue((boolean)queryStatusChecker.isQueryRunning());
            ((AmazonAthena)Mockito.verify((Object)this.athena, (VerificationMode)Mockito.times((int)2))).getQueryExecution((GetQueryExecutionRequest)Matchers.any());
        }
    }
}

