/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.FieldBuilder;
import com.amazonaws.athena.connector.lambda.data.FieldResolver;
import com.amazonaws.athena.connector.lambda.data.RecordBatchSerDe;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.data.SchemaSerDe;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintEvaluator;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.EquatableValueSet;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.commons.codec.Charsets;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTest {
    private static final String ENTRIES = "entries";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final Logger logger = LoggerFactory.getLogger(BlockTest.class);
    private BlockAllocatorImpl allocator;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void constrainedBlockTest() throws Exception {
        Schema schema = SchemaBuilder.newBuilder().addIntField("col1").addIntField("col2").build();
        Block block = this.allocator.createBlock(schema);
        EquatableValueSet col1Constraint = EquatableValueSet.newBuilder((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (boolean)true, (boolean)false).add((Object)10).build();
        Constraints constraints = new Constraints(Collections.singletonMap("col1", col1Constraint));
        try (ConstraintEvaluator constraintEvaluator = new ConstraintEvaluator((BlockAllocator)this.allocator, schema, constraints);){
            block.constrain(constraintEvaluator);
            Assert.assertTrue((boolean)block.setValue("col1", 0, (Object)10));
            Assert.assertTrue((boolean)block.offerValue("col1", 0, (Object)10));
            Assert.assertFalse((boolean)block.setValue("col1", 0, (Object)11));
            Assert.assertFalse((boolean)block.offerValue("col1", 0, (Object)11));
            Assert.assertTrue((boolean)block.offerValue("unkown_col", 0, (Object)10));
        }
    }

    @Test
    public void EndToEndBlockTest() throws Exception {
        FieldReader vector;
        BlockAllocatorImpl expectedAllocator = new BlockAllocatorImpl();
        int expectedRows = 200;
        Schema origSchema = BlockTest.generateTestSchema();
        Block expectedBlock = BlockTest.generateTestBlock(expectedAllocator, origSchema, expectedRows);
        RecordBatchSerDe expectSerDe = new RecordBatchSerDe((BlockAllocator)expectedAllocator);
        ByteArrayOutputStream blockOut = new ByteArrayOutputStream();
        ArrowRecordBatch expectedBatch = expectedBlock.getRecordBatch();
        expectSerDe.serialize(expectedBatch, (OutputStream)blockOut);
        this.assertSerializationOverhead(blockOut);
        expectedBatch.close();
        expectedBlock.close();
        ByteArrayOutputStream schemaOut = new ByteArrayOutputStream();
        SchemaSerDe schemaSerDe = new SchemaSerDe();
        schemaSerDe.serialize(origSchema, (OutputStream)schemaOut);
        Schema actualSchema = schemaSerDe.deserialize((InputStream)new ByteArrayInputStream(schemaOut.toByteArray()));
        BlockAllocatorImpl actualAllocator = new BlockAllocatorImpl();
        RecordBatchSerDe actualSerDe = new RecordBatchSerDe((BlockAllocator)actualAllocator);
        ArrowRecordBatch batch = actualSerDe.deserialize(blockOut.toByteArray());
        Block actualBlock = actualAllocator.createBlock(actualSchema);
        actualBlock.loadRecordBatch(batch);
        batch.close();
        for (int i = 0; i < actualBlock.getRowCount(); ++i) {
            logger.info("EndToEndBlockTest: util {}", (Object)BlockUtils.rowToString((Block)actualBlock, (int)i));
        }
        Assert.assertEquals((String)"Row count missmatch", (long)expectedRows, (long)actualBlock.getRowCount());
        int actualFieldCount = 1;
        for (Field next : actualBlock.getFields()) {
            vector = actualBlock.getFieldReader(next.getName());
            switch (vector.getMinorType()) {
                case INT: {
                    FieldReader intVector = vector;
                    for (int i = 0; i < actualBlock.getRowCount(); ++i) {
                        intVector.setPosition(i);
                        Assert.assertEquals((long)(i * actualFieldCount * 3), (long)intVector.readInteger().intValue());
                    }
                    break;
                }
                case FLOAT8: {
                    FieldReader fVector = vector;
                    for (int i = 0; i < actualBlock.getRowCount(); ++i) {
                        fVector.setPosition(i);
                        Assert.assertEquals((double)((double)(i * actualFieldCount) * 1.1), (double)fVector.readDouble(), (double)0.1);
                    }
                    break;
                }
                case VARCHAR: {
                    int i;
                    FieldReader vVector = vector;
                    for (i = 0; i < actualBlock.getRowCount(); ++i) {
                        vVector.setPosition(i);
                        Assert.assertEquals((Object)String.valueOf(i * actualFieldCount), (Object)vVector.readText().toString());
                    }
                    break;
                }
                case STRUCT: {
                    int i;
                    for (i = 0; i < actualBlock.getRowCount(); ++i) {
                        FieldReader effectiveVector = vector;
                        if (vector.getField().getName().equals("structFieldNested28")) {
                            effectiveVector = vector.reader("nestedStruct");
                        }
                        effectiveVector.setPosition(i);
                        Assert.assertEquals((String)(" name: " + effectiveVector.getField().getName()), (Object)i, (Object)effectiveVector.reader("nestedBigInt").readLong());
                        Assert.assertEquals((Object)String.valueOf(1000 + i), (Object)effectiveVector.reader("nestedString").readText().toString());
                    }
                    break;
                }
                case LIST: {
                    int actual = 0;
                    Field child = (Field)vector.getField().getChildren().get(0);
                    for (int i = 0; i < actualBlock.getRowCount(); ++i) {
                        vector.setPosition(i);
                        int entryValues = 0;
                        while (vector.next()) {
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.BIGINT) {
                                Assert.assertEquals((Object)(i + entryValues++), (Object)vector.reader().readLong());
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.VARCHAR) {
                                Assert.assertEquals((Object)String.valueOf(1000 + i + entryValues++), (Object)vector.reader().readText().toString());
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.SMALLINT) {
                                ++entryValues;
                                Assert.assertTrue((new Integer(i + 1).shortValue() == vector.reader().readShort().shortValue() ? 1 : 0) != 0);
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.INT) {
                                ++entryValues;
                                Assert.assertTrue((i == vector.reader().readInteger() ? 1 : 0) != 0);
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.TINYINT) {
                                ++entryValues;
                                Assert.assertTrue(((byte)i == vector.reader().readByte() ? 1 : 0) != 0);
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.FLOAT4) {
                                ++entryValues;
                                Assert.assertTrue(((float)i * 1.0f == vector.reader().readFloat().floatValue() ? 1 : 0) != 0);
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.FLOAT8) {
                                ++entryValues;
                                Assert.assertTrue(((double)i * 1.0 == vector.reader().readDouble() ? 1 : 0) != 0);
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.DECIMAL) {
                                ++entryValues;
                                Assert.assertTrue(((long)i * 100L == vector.reader().readBigDecimal().unscaledValue().longValue() ? 1 : 0) != 0);
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.VARBINARY) {
                                ++entryValues;
                                continue;
                            }
                            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) != Types.MinorType.BIT) continue;
                            ++entryValues;
                            Assert.assertTrue((i % 2 == 1 == vector.reader().readBoolean() ? 1 : 0) != 0);
                        }
                        if (entryValues <= 0) continue;
                        ++actual;
                    }
                    Assert.assertEquals((String)("failed for " + vector.getField().getName()), (long)actualBlock.getRowCount(), (long)actual);
                    break;
                }
            }
            ++actualFieldCount;
        }
        BlockUtils.unsetRow((int)0, (Block)actualBlock);
        for (Field next : actualBlock.getFields()) {
            vector = actualBlock.getFieldReader(next.getName());
            switch (vector.getMinorType()) {
                case INT: 
                case FLOAT8: 
                case VARCHAR: 
                case STRUCT: 
                case DATEDAY: 
                case DATEMILLI: 
                case TINYINT: 
                case UINT1: 
                case SMALLINT: 
                case UINT2: 
                case UINT4: 
                case UINT8: 
                case BIGINT: 
                case FLOAT4: 
                case DECIMAL: 
                case VARBINARY: 
                case BIT: 
                case MAP: {
                    vector.setPosition(0);
                    Assert.assertFalse((String)("Failed for " + vector.getMinorType() + " " + next.getName()), (boolean)vector.isSet());
                    break;
                }
                case LIST: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(next.getType().getTypeID() + " is not supported");
                }
            }
            ++actualFieldCount;
        }
        logger.info("EndToEndBlockTest: block size {}", (Object)actualAllocator.getUsage());
        actualBlock.close();
    }

    public static Schema generateTestSchema() {
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addMetadata("meta1", "meta-value-1");
        schemaBuilder.addMetadata("meta2", "meta-value-2");
        schemaBuilder.addField("intfield1", (ArrowType)new ArrowType.Int(32, true));
        schemaBuilder.addField("doublefield2", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
        schemaBuilder.addField("varcharfield3", (ArrowType)new ArrowType.Utf8());
        schemaBuilder.addField("datemillifield4", (ArrowType)new ArrowType.Date(DateUnit.MILLISECOND));
        schemaBuilder.addField("tinyintfield5", (ArrowType)new ArrowType.Int(8, true));
        schemaBuilder.addField("uint1field6", (ArrowType)new ArrowType.Int(8, false));
        schemaBuilder.addField("smallintfield7", (ArrowType)new ArrowType.Int(16, true));
        schemaBuilder.addField("uint2field8", (ArrowType)new ArrowType.Int(16, false));
        schemaBuilder.addField("datedayfield9", (ArrowType)new ArrowType.Date(DateUnit.DAY));
        schemaBuilder.addField("uint4field10", (ArrowType)new ArrowType.Int(32, false));
        schemaBuilder.addField("bigintfield11", (ArrowType)new ArrowType.Int(64, true));
        schemaBuilder.addField("decimalfield12", (ArrowType)new ArrowType.Decimal(10, 2));
        schemaBuilder.addField("floatfield13", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE));
        schemaBuilder.addField("varbinaryfield14", (ArrowType)new ArrowType.Binary());
        schemaBuilder.addField("bitfield15", (ArrowType)new ArrowType.Bool());
        schemaBuilder.addListField("varcharlist16", Types.MinorType.VARCHAR.getType());
        schemaBuilder.addListField("intlist17", Types.MinorType.INT.getType());
        schemaBuilder.addListField("bigintlist18", Types.MinorType.BIGINT.getType());
        schemaBuilder.addListField("tinyintlist19", Types.MinorType.TINYINT.getType());
        schemaBuilder.addListField("smallintlist20", Types.MinorType.SMALLINT.getType());
        schemaBuilder.addListField("float4list21", Types.MinorType.FLOAT4.getType());
        schemaBuilder.addListField("float8list22", Types.MinorType.FLOAT8.getType());
        schemaBuilder.addListField("shortdeclist23", (ArrowType)new ArrowType.Decimal(10, 2));
        schemaBuilder.addListField("londdeclist24", (ArrowType)new ArrowType.Decimal(21, 2));
        schemaBuilder.addListField("varbinarylist25", Types.MinorType.VARBINARY.getType());
        schemaBuilder.addListField("bitlist26", Types.MinorType.BIT.getType());
        schemaBuilder.addStructField("structField27");
        schemaBuilder.addChildField("structField27", "nestedBigInt", Types.MinorType.BIGINT.getType());
        schemaBuilder.addChildField("structField27", "nestedString", Types.MinorType.VARCHAR.getType());
        schemaBuilder.addChildField("structField27", "tinyintcol", Types.MinorType.TINYINT.getType());
        schemaBuilder.addChildField("structField27", "smallintcol", Types.MinorType.SMALLINT.getType());
        schemaBuilder.addChildField("structField27", "float4Col", Types.MinorType.FLOAT4.getType());
        schemaBuilder.addChildField("structField27", "float8Col", Types.MinorType.FLOAT8.getType());
        schemaBuilder.addChildField("structField27", "shortDecCol", (ArrowType)new ArrowType.Decimal(10, 2));
        schemaBuilder.addChildField("structField27", "longDecCol", (ArrowType)new ArrowType.Decimal(21, 2));
        schemaBuilder.addChildField("structField27", "binaryCol", Types.MinorType.VARBINARY.getType());
        schemaBuilder.addChildField("structField27", "bitCol", Types.MinorType.BIT.getType());
        schemaBuilder.addStructField("structFieldNested28");
        schemaBuilder.addChildField("structFieldNested28", "bitCol", Types.MinorType.BIT.getType());
        schemaBuilder.addChildField("structFieldNested28", FieldBuilder.newBuilder((String)"nestedStruct", (ArrowType)new ArrowType.Struct()).addField("nestedString", Types.MinorType.VARCHAR.getType(), null).addField("nestedBigInt", Types.MinorType.BIGINT.getType(), null).addListField("nestedList", Types.MinorType.VARCHAR.getType()).addListField("nestedListDec", (ArrowType)new ArrowType.Decimal(10, 2)).build());
        schemaBuilder.addField(FieldBuilder.newBuilder((String)"simplemap", (ArrowType)new ArrowType.Map(false)).addField(ENTRIES, Types.MinorType.STRUCT.getType(), false, Arrays.asList(FieldBuilder.newBuilder((String)KEY, (ArrowType)Types.MinorType.VARCHAR.getType(), (boolean)false).build(), FieldBuilder.newBuilder((String)VALUE, (ArrowType)Types.MinorType.INT.getType()).build())).build());
        return schemaBuilder.build();
    }

    public static Block generateTestBlock(BlockAllocatorImpl expectedAllocator, Schema origSchema, int expectedRows) throws UnsupportedOperationException {
        Block expectedBlock = expectedAllocator.createBlock(origSchema);
        int fieldCount = 1;
        for (Field next : origSchema.getFields()) {
            FieldVector vector = expectedBlock.getFieldVector(next.getName());
            switch (vector.getMinorType()) {
                case DATEDAY: {
                    DateDayVector dateDayVector = (DateDayVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        dateDayVector.setSafe(i, i * fieldCount);
                    }
                    break;
                }
                case UINT4: {
                    UInt4Vector uInt4Vector = (UInt4Vector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        uInt4Vector.setSafe(i, i * fieldCount * 2);
                    }
                    break;
                }
                case INT: {
                    IntVector intVector = (IntVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        intVector.setSafe(i, i * fieldCount * 3);
                    }
                    break;
                }
                case FLOAT8: {
                    Float8Vector fVector = (Float8Vector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        fVector.setSafe(i, (double)(i * fieldCount) * 1.1);
                    }
                    break;
                }
                case VARCHAR: {
                    VarCharVector vVector = (VarCharVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        vVector.setSafe(i, String.valueOf(i * fieldCount).getBytes(Charsets.UTF_8));
                    }
                    break;
                }
                case DATEMILLI: {
                    DateMilliVector dateMilliVector = (DateMilliVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        dateMilliVector.setSafe(i, (long)(i * fieldCount * 4));
                    }
                    break;
                }
                case TINYINT: {
                    TinyIntVector tinyIntVector = (TinyIntVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        tinyIntVector.setSafe(i, i * fieldCount * 5);
                    }
                    break;
                }
                case UINT1: {
                    UInt1Vector uInt1Vector = (UInt1Vector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        uInt1Vector.setSafe(i, i * fieldCount * 6);
                    }
                    break;
                }
                case SMALLINT: {
                    SmallIntVector smallIntVector = (SmallIntVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        smallIntVector.setSafe(i, i * fieldCount * 7);
                    }
                    break;
                }
                case UINT2: {
                    UInt2Vector uInt2Vector = (UInt2Vector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        uInt2Vector.setSafe(i, i * fieldCount * 8);
                    }
                    break;
                }
                case UINT8: {
                    UInt8Vector uInt8Vector = (UInt8Vector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        uInt8Vector.setSafe(i, (long)(i * fieldCount * 9));
                    }
                    break;
                }
                case BIGINT: {
                    BigIntVector bigIntVector = (BigIntVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        bigIntVector.setSafe(i, (long)(i * fieldCount * 10));
                    }
                    break;
                }
                case DECIMAL: {
                    DecimalVector decimalVector = (DecimalVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        BigDecimal bigDecimal = new BigDecimal((double)(i * fieldCount) * 1.01);
                        bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
                        decimalVector.setSafe(i, bigDecimal);
                    }
                    break;
                }
                case FLOAT4: {
                    Float4Vector float4Vector = (Float4Vector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        float4Vector.setSafe(i, (float)(i * fieldCount * 9));
                    }
                    break;
                }
                case VARBINARY: {
                    VarBinaryVector varBinaryVector = (VarBinaryVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        byte[] data = String.valueOf(i * fieldCount).getBytes();
                        varBinaryVector.setSafe(i, data);
                    }
                    break;
                }
                case BIT: {
                    BitVector bitVector = (BitVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        bitVector.setSafe(i, i % 2);
                    }
                    break;
                }
                case STRUCT: {
                    StructVector sVector = (StructVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        int seed = i;
                        BlockUtils.setComplexValue((FieldVector)sVector, (int)i, (field, value) -> {
                            if (field.getName().equals("nestedBigInt")) {
                                return (long)seed;
                            }
                            if (field.getName().equals("nestedString")) {
                                return String.valueOf(1000 + seed);
                            }
                            if (field.getName().equals("tinyintcol")) {
                                return (byte)seed;
                            }
                            if (field.getName().equals("smallintcol")) {
                                return (short)seed;
                            }
                            if (field.getName().equals("nestedList")) {
                                ArrayList<String> values = new ArrayList<String>();
                                values.add("val1");
                                values.add("val2");
                                return values;
                            }
                            if (field.getName().equals("nestedListDec")) {
                                ArrayList<Double> values = new ArrayList<Double>();
                                values.add(2.0);
                                values.add(2.2);
                                return values;
                            }
                            if (field.getName().equals("float4Col")) {
                                return Float.valueOf((float)seed * 1.0f);
                            }
                            if (field.getName().equals("float8Col")) {
                                return (double)seed * 2.0;
                            }
                            if (field.getName().equals("shortDecCol")) {
                                return (double)seed * 3.0;
                            }
                            if (field.getName().equals("longDecCol")) {
                                return (double)seed * 4.0;
                            }
                            if (field.getName().equals("binaryCol")) {
                                return String.valueOf(seed).getBytes(Charsets.UTF_8);
                            }
                            if (field.getName().equals("bitCol")) {
                                return seed % 2 == 1;
                            }
                            if (field.getName().equals("nestedStruct")) {
                                return new Object();
                            }
                            throw new RuntimeException("Unexpected field " + field.getName());
                        }, (Object)new Object());
                    }
                    break;
                }
                case LIST: {
                    ArrayList<Object> values;
                    Field child = (Field)vector.getField().getChildren().get(0);
                    if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.BIGINT) {
                        for (int i = 0; i < expectedRows; ++i) {
                            values = new ArrayList<Object>();
                            values.add(Long.valueOf(i));
                            values.add((long)i + 1L);
                            values.add((long)i + 2L);
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, values);
                        }
                    } else if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.VARCHAR) {
                        for (int i = 0; i < expectedRows; ++i) {
                            values = new ArrayList();
                            values.add(String.valueOf(1000 + i));
                            values.add(String.valueOf(1000 + i + 1));
                            values.add(String.valueOf(1000 + i + 2));
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, values);
                        }
                    } else if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.SMALLINT) {
                        for (int i = 0; i < expectedRows; ++i) {
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, Collections.singletonList((short)(i + 1)));
                        }
                    } else if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.INT) {
                        for (int i = 0; i < expectedRows; ++i) {
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, Collections.singletonList(i));
                        }
                    } else if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.TINYINT) {
                        for (int i = 0; i < expectedRows; ++i) {
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, Collections.singletonList((byte)i));
                        }
                    } else if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.FLOAT4) {
                        for (int i = 0; i < expectedRows; ++i) {
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, Collections.singletonList(Float.valueOf((float)i * 1.0f)));
                        }
                    } else if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.FLOAT8) {
                        for (int i = 0; i < expectedRows; ++i) {
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, Collections.singletonList((double)i * 1.0));
                        }
                    } else if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.DECIMAL) {
                        for (int i = 0; i < expectedRows; ++i) {
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, Collections.singletonList((double)i * 1.0));
                        }
                    } else if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) == Types.MinorType.VARBINARY) {
                        for (int i = 0; i < expectedRows; ++i) {
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, Collections.singletonList(String.valueOf(i).getBytes(Charsets.UTF_8)));
                        }
                    } else {
                        if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) != Types.MinorType.BIT) break;
                        for (int i = 0; i < expectedRows; ++i) {
                            BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, Collections.singletonList(i % 2 == 1));
                        }
                    }
                    break;
                }
                case MAP: {
                    MapVector mapVector = (MapVector)vector;
                    for (int i = 0; i < expectedRows; ++i) {
                        int seed = i;
                        BlockUtils.setComplexValue((FieldVector)mapVector, (int)i, (field, value) -> {
                            if (field.getName().equals(KEY)) {
                                return String.valueOf(1000 + seed);
                            }
                            if (field.getName().equals(VALUE)) {
                                return seed;
                            }
                            if (field.getName().equals("tinyintcol")) {
                                return (byte)seed;
                            }
                            if (field.getName().equals("smallintcol")) {
                                return (short)seed;
                            }
                            if (field.getName().equals("nestedList")) {
                                ArrayList<String> values = new ArrayList<String>();
                                values.add("val1");
                                values.add("val2");
                                return values;
                            }
                            if (field.getName().equals("nestedListDec")) {
                                ArrayList<Double> values = new ArrayList<Double>();
                                values.add(2.0);
                                values.add(2.2);
                                return values;
                            }
                            if (field.getName().equals("float4Col")) {
                                return Float.valueOf((float)seed * 1.0f);
                            }
                            if (field.getName().equals("float8Col")) {
                                return (double)seed * 2.0;
                            }
                            if (field.getName().equals("shortDecCol")) {
                                return (double)seed * 3.0;
                            }
                            if (field.getName().equals("longDecCol")) {
                                return (double)seed * 4.0;
                            }
                            if (field.getName().equals("binaryCol")) {
                                return String.valueOf(seed).getBytes(Charsets.UTF_8);
                            }
                            if (field.getName().equals("bitCol")) {
                                return seed % 2 == 1;
                            }
                            if (field.getName().equals("nestedStruct")) {
                                return new Object();
                            }
                            throw new RuntimeException("Unexpected field " + field.getName());
                        }, Map.of());
                    }
                    List children = vector.getField().getChildren();
                    if (children.size() != 1) {
                        throw new IllegalStateException("Invalid Arrow Map schema: " + vector.getField());
                    }
                    Field keyValueStructField = (Field)children.get(0);
                    if (!ENTRIES.equals(keyValueStructField.getName()) || !(keyValueStructField.getType() instanceof ArrowType.Struct)) {
                        throw new IllegalStateException("Invalid Arrow Map schema: " + vector.getField());
                    }
                    List keyValueChildren = keyValueStructField.getChildren();
                    if (keyValueChildren.size() != 2) {
                        throw new IllegalStateException("Invalid Arrow Map schema: " + vector.getField());
                    }
                    Field keyField = (Field)keyValueChildren.get(0);
                    Field valueField = (Field)keyValueChildren.get(1);
                    if (KEY.equals(keyField.getName()) && VALUE.equals(valueField.getName())) break;
                    throw new IllegalStateException("Invalid Arrow Map schema: " + vector.getField());
                }
                default: {
                    throw new UnsupportedOperationException(vector.getMinorType() + " is not supported");
                }
            }
            ++fieldCount;
        }
        expectedBlock.setRowCount(expectedRows);
        return expectedBlock;
    }

    @Test
    public void ListOfListsTest() throws Exception {
        BlockAllocatorImpl expectedAllocator = new BlockAllocatorImpl();
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addField(FieldBuilder.newBuilder((String)"outerlist", (ArrowType)new ArrowType.List()).addListField("innerList", Types.MinorType.VARCHAR.getType()).build());
        Schema origSchema = schemaBuilder.build();
        Block expectedBlock = expectedAllocator.createBlock(origSchema);
        int expectedRows = 200;
        block9: for (Field next : origSchema.getFields()) {
            FieldVector vector = expectedBlock.getFieldVector(next.getName());
            switch (vector.getMinorType()) {
                case LIST: {
                    Field child = (Field)vector.getField().getChildren().get(0);
                    for (int i = 0; i < expectedRows; ++i) {
                        ArrayList value = new ArrayList();
                        switch (Types.getMinorTypeForArrowType((ArrowType)child.getType())) {
                            case LIST: {
                                ArrayList<String> values = new ArrayList<String>();
                                values.add(String.valueOf(1000));
                                values.add(String.valueOf(1001));
                                values.add(String.valueOf(1002));
                                value.add(values);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException(vector.getMinorType() + " is not supported");
                            }
                        }
                        BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, value);
                    }
                    continue block9;
                }
                default: {
                    throw new UnsupportedOperationException(vector.getMinorType() + " is not supported");
                }
            }
        }
        expectedBlock.setRowCount(expectedRows);
        RecordBatchSerDe expectSerDe = new RecordBatchSerDe((BlockAllocator)expectedAllocator);
        ByteArrayOutputStream blockOut = new ByteArrayOutputStream();
        ArrowRecordBatch expectedBatch = expectedBlock.getRecordBatch();
        expectSerDe.serialize(expectedBatch, (OutputStream)blockOut);
        this.assertSerializationOverhead(blockOut);
        expectedBatch.close();
        expectedBlock.close();
        ByteArrayOutputStream schemaOut = new ByteArrayOutputStream();
        SchemaSerDe schemaSerDe = new SchemaSerDe();
        schemaSerDe.serialize(origSchema, (OutputStream)schemaOut);
        Schema actualSchema = schemaSerDe.deserialize((InputStream)new ByteArrayInputStream(schemaOut.toByteArray()));
        BlockAllocatorImpl actualAllocator = new BlockAllocatorImpl();
        RecordBatchSerDe actualSerDe = new RecordBatchSerDe((BlockAllocator)actualAllocator);
        ArrowRecordBatch batch = actualSerDe.deserialize(blockOut.toByteArray());
        Block actualBlock = actualAllocator.createBlock(actualSchema);
        actualBlock.loadRecordBatch(batch);
        batch.close();
        for (int i = 0; i < actualBlock.getRowCount(); ++i) {
            logger.info("ListOfList: util {}", (Object)BlockUtils.rowToString((Block)actualBlock, (int)i));
        }
        Assert.assertEquals((String)"Row count missmatch", (long)expectedRows, (long)actualBlock.getRowCount());
        int actualFieldCount = 1;
        for (Field next : actualBlock.getFields()) {
            FieldReader vector = actualBlock.getFieldReader(next.getName());
            switch (vector.getMinorType()) {
                case LIST: {
                    int actual = 0;
                    for (int i = 0; i < actualBlock.getRowCount(); ++i) {
                        vector.setPosition(i);
                        int entryValues = 0;
                        while (vector.next()) {
                            FieldReader innerReader = vector.reader();
                            int j = 0;
                            while (innerReader.next()) {
                                ++entryValues;
                                Assert.assertEquals((Object)String.valueOf(1000 + j++), (Object)innerReader.reader().readText().toString());
                            }
                        }
                        if (entryValues <= 0) continue;
                        ++actual;
                    }
                    Assert.assertEquals((String)("failed for " + vector.getField().getName()), (long)actualBlock.getRowCount(), (long)actual);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(next.getType().getTypeID() + " is not supported");
                }
            }
            ++actualFieldCount;
        }
        actualBlock.close();
    }

    @Test
    public void ListOfStructsTest() throws Exception {
        BlockAllocatorImpl expectedAllocator = new BlockAllocatorImpl();
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addField(FieldBuilder.newBuilder((String)"outerlist", (ArrowType)new ArrowType.List()).addField(FieldBuilder.newBuilder((String)"innerStruct", (ArrowType)Types.MinorType.STRUCT.getType()).addStringField("varchar").addBigIntField("bigint").build()).build());
        Schema origSchema = schemaBuilder.build();
        Block expectedBlock = expectedAllocator.createBlock(origSchema);
        int expectedRows = 200;
        block9: for (Field next : origSchema.getFields()) {
            FieldVector vector = expectedBlock.getFieldVector(next.getName());
            switch (vector.getMinorType()) {
                case LIST: {
                    Field child = (Field)vector.getField().getChildren().get(0);
                    for (int i = 0; i < expectedRows; ++i) {
                        ArrayList value = new ArrayList();
                        switch (Types.getMinorTypeForArrowType((ArrowType)child.getType())) {
                            case STRUCT: {
                                HashMap<String, Object> values = new HashMap<String, Object>();
                                values.put("varchar", "chars");
                                values.put("bigint", 100L);
                                value.add(values);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException(vector.getMinorType() + " is not supported");
                            }
                        }
                        BlockUtils.setComplexValue((FieldVector)((ListVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, value);
                    }
                    continue block9;
                }
                default: {
                    throw new UnsupportedOperationException(vector.getMinorType() + " is not supported");
                }
            }
        }
        expectedBlock.setRowCount(expectedRows);
        RecordBatchSerDe expectSerDe = new RecordBatchSerDe((BlockAllocator)expectedAllocator);
        ByteArrayOutputStream blockOut = new ByteArrayOutputStream();
        ArrowRecordBatch expectedBatch = expectedBlock.getRecordBatch();
        expectSerDe.serialize(expectedBatch, (OutputStream)blockOut);
        this.assertSerializationOverhead(blockOut);
        expectedBatch.close();
        expectedBlock.close();
        ByteArrayOutputStream schemaOut = new ByteArrayOutputStream();
        SchemaSerDe schemaSerDe = new SchemaSerDe();
        schemaSerDe.serialize(origSchema, (OutputStream)schemaOut);
        Schema actualSchema = schemaSerDe.deserialize((InputStream)new ByteArrayInputStream(schemaOut.toByteArray()));
        BlockAllocatorImpl actualAllocator = new BlockAllocatorImpl();
        RecordBatchSerDe actualSerDe = new RecordBatchSerDe((BlockAllocator)actualAllocator);
        ArrowRecordBatch batch = actualSerDe.deserialize(blockOut.toByteArray());
        Block actualBlock = actualAllocator.createBlock(actualSchema);
        actualBlock.loadRecordBatch(batch);
        batch.close();
        for (int i = 0; i < actualBlock.getRowCount(); ++i) {
            logger.info("ListOfList: util {}", (Object)BlockUtils.rowToString((Block)actualBlock, (int)i));
        }
        Assert.assertEquals((String)"Row count missmatch", (long)expectedRows, (long)actualBlock.getRowCount());
        int actualFieldCount = 1;
        for (Field next : actualBlock.getFields()) {
            FieldReader vector = actualBlock.getFieldReader(next.getName());
            switch (vector.getMinorType()) {
                case LIST: {
                    int actual = 0;
                    for (int i = 0; i < actualBlock.getRowCount(); ++i) {
                        vector.setPosition(i);
                        int entryValues = 0;
                        while (vector.next()) {
                            ++entryValues;
                            Assert.assertEquals((Object)"chars", (Object)vector.reader().reader("varchar").readText().toString());
                            Assert.assertEquals((Object)100L, (Object)vector.reader().reader("bigint").readLong());
                        }
                        if (entryValues <= 0) continue;
                        ++actual;
                    }
                    Assert.assertEquals((String)("failed for " + vector.getField().getName()), (long)actualBlock.getRowCount(), (long)actual);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(next.getType().getTypeID() + " is not supported");
                }
            }
            ++actualFieldCount;
        }
        actualBlock.close();
    }

    @Test
    public void structOfListsTest() throws Exception {
        BlockAllocatorImpl expectedAllocator = new BlockAllocatorImpl();
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addField(FieldBuilder.newBuilder((String)"innerStruct", (ArrowType)Types.MinorType.STRUCT.getType()).addStringField("varchar").addListField("list", Types.MinorType.VARCHAR.getType()).build());
        Schema origSchema = schemaBuilder.build();
        Block expectedBlock = expectedAllocator.createBlock(origSchema);
        int expectedRows = 200;
        for (Field next : origSchema.getFields()) {
            FieldVector vector = expectedBlock.getFieldVector(next.getName());
            block7: for (int i = 0; i < expectedRows; ++i) {
                switch (vector.getMinorType()) {
                    case STRUCT: {
                        HashMap<String, Object> value = new HashMap<String, Object>();
                        value.put("varchar", "chars");
                        if (i % 2 == 0) {
                            ArrayList<CallSite> listVal = new ArrayList<CallSite>();
                            listVal.add((CallSite)((Object)("value_0_" + i)));
                            listVal.add((CallSite)((Object)("value_1_" + i)));
                            value.put("list", listVal);
                        } else {
                            value.put("list", null);
                        }
                        BlockUtils.setComplexValue((FieldVector)((StructVector)vector), (int)i, (FieldResolver)FieldResolver.DEFAULT, value);
                        continue block7;
                    }
                    default: {
                        throw new UnsupportedOperationException(vector.getMinorType() + " is not supported");
                    }
                }
            }
        }
        expectedBlock.setRowCount(expectedRows);
        RecordBatchSerDe expectSerDe = new RecordBatchSerDe((BlockAllocator)expectedAllocator);
        ByteArrayOutputStream blockOut = new ByteArrayOutputStream();
        ArrowRecordBatch expectedBatch = expectedBlock.getRecordBatch();
        expectSerDe.serialize(expectedBatch, (OutputStream)blockOut);
        this.assertSerializationOverhead(blockOut);
        expectedBatch.close();
        expectedBlock.close();
        ByteArrayOutputStream schemaOut = new ByteArrayOutputStream();
        SchemaSerDe schemaSerDe = new SchemaSerDe();
        schemaSerDe.serialize(origSchema, (OutputStream)schemaOut);
        Schema actualSchema = schemaSerDe.deserialize((InputStream)new ByteArrayInputStream(schemaOut.toByteArray()));
        BlockAllocatorImpl actualAllocator = new BlockAllocatorImpl();
        RecordBatchSerDe actualSerDe = new RecordBatchSerDe((BlockAllocator)actualAllocator);
        ArrowRecordBatch batch = actualSerDe.deserialize(blockOut.toByteArray());
        Block actualBlock = actualAllocator.createBlock(actualSchema);
        actualBlock.loadRecordBatch(batch);
        batch.close();
        for (int i = 0; i < actualBlock.getRowCount(); ++i) {
            logger.info("ListOfList: util {}", (Object)BlockUtils.rowToString((Block)actualBlock, (int)i));
        }
        Assert.assertEquals((String)"Row count missmatch", (long)expectedRows, (long)actualBlock.getRowCount());
        int actualListValues = 0;
        int emptyListValues = 0;
        for (Field next : actualBlock.getFields()) {
            FieldReader vector = actualBlock.getFieldReader(next.getName());
            block10: for (int i = 0; i < actualBlock.getRowCount(); ++i) {
                switch (vector.getMinorType()) {
                    case STRUCT: {
                        vector.setPosition(i);
                        Assert.assertEquals((Object)"chars", (Object)vector.reader("varchar").readText().toString());
                        FieldReader listReader = vector.reader("list");
                        int found = 0;
                        while (listReader.next()) {
                            Assert.assertEquals((Object)("value_" + found + "_" + i), (Object)listReader.reader().readText().toString());
                            ++found;
                            ++actualListValues;
                        }
                        if (found != 0) continue block10;
                        ++emptyListValues;
                        continue block10;
                    }
                    default: {
                        throw new UnsupportedOperationException(next.getType().getTypeID() + " is not supported");
                    }
                }
            }
        }
        actualBlock.close();
        Assert.assertEquals((long)200L, (long)actualListValues);
        Assert.assertEquals((long)100L, (long)emptyListValues);
        logger.info("structOfListsTest: actualListValues[{}] emptyListValues[{}]", (Object)actualListValues, (Object)emptyListValues);
    }

    private void assertSerializationOverhead(ByteArrayOutputStream serializedBlock) {
        try {
            ByteArrayOutputStream jout = new ByteArrayOutputStream();
            JsonFactory factory = new JsonFactory();
            JsonGenerator jsonGenerator = factory.createGenerator((OutputStream)jout);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeBinaryField("field", serializedBlock.toByteArray());
            jsonGenerator.close();
            double overhead = 1.0 - (double)serializedBlock.size() / (double)jout.size();
            logger.info("assertSerializationOverhead: {} vs {} = {}", new Object[]{serializedBlock.size(), jout.size(), overhead});
            Assert.assertTrue((0.35 > overhead ? 1 : 0) != 0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

