/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.ArrowToArrowResolver;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.BlockUtilsTest;
import com.amazonaws.athena.connector.lambda.data.FieldResolver;
import com.amazonaws.athena.connector.lambda.data.helpers.CustomFieldVector;
import com.amazonaws.athena.connector.lambda.data.helpers.FieldsGenerator;
import com.amazonaws.athena.connector.lambda.data.helpers.ValuesGenerator;
import java.util.List;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockUtilsPropertiesTest {
    private static final Logger logger = LoggerFactory.getLogger(BlockUtilsTest.class);

    @Provide
    protected Arbitrary<Field> fieldLowRecursion() {
        FieldsGenerator fieldsGenerator = new FieldsGenerator(2);
        return fieldsGenerator.field();
    }

    @Provide
    protected Arbitrary<Field> fieldHighRecursion() {
        FieldsGenerator fieldsGenerator = new FieldsGenerator(5);
        return fieldsGenerator.field();
    }

    protected FieldResolver getFieldResolver(Schema schema) {
        return new ArrowToArrowResolver();
    }

    protected Object getValue(FieldVector vector, CustomFieldVector customFieldVector, int pos, FieldResolver resolver) {
        if (vector.getMinorType().equals((Object)Types.MinorType.MAP)) {
            return resolver.getFieldValue(vector.getField(), vector.getObject(pos));
        }
        return vector.getObject(pos);
    }

    @Property
    boolean setComplexValuesSetsAllFieldsCorrectlyGivenAnyInputHighRecursion(@ForAll(value="fieldHighRecursion") Field field) {
        return this.setComplexValuesSetsAllFieldsCorrectlyGivenAnyInput(field);
    }

    @Property(tries=2000, edgeCases=EdgeCasesMode.FIRST)
    boolean setComplexValuesSetsAllFieldsCorrectlyGivenAnyInputAllCombinations(@ForAll(value="fieldLowRecursion") Field field) {
        return this.setComplexValuesSetsAllFieldsCorrectlyGivenAnyInput(field);
    }

    private boolean setComplexValuesSetsAllFieldsCorrectlyGivenAnyInput(Field field) {
        ValuesGenerator generator = new ValuesGenerator();
        RootAllocator allocator = new RootAllocator();
        FieldVector vector = field.createVector((BufferAllocator)allocator);
        CustomFieldVector customFieldVector = new CustomFieldVector(field);
        generator.generateValues(field, vector, customFieldVector);
        Schema schema = new Schema(List.of(field));
        VectorSchemaRoot inputSchemaRoot = new VectorSchemaRoot(schema, List.of(vector), 1);
        int valueCount = inputSchemaRoot.getVector(0).getValueCount();
        VectorSchemaRoot outputSchemaRoot = VectorSchemaRoot.create((Schema)inputSchemaRoot.getSchema(), (BufferAllocator)allocator);
        outputSchemaRoot.setRowCount(1);
        FieldResolver resolver = this.getFieldResolver(schema);
        for (int i = 0; i < valueCount; ++i) {
            if (field.getType().isComplex()) {
                BlockUtils.setComplexValue((FieldVector)outputSchemaRoot.getVector(0), (int)i, (FieldResolver)resolver, (Object)this.getValue(vector, customFieldVector, i, resolver));
                continue;
            }
            BlockUtils.setValue((FieldVector)outputSchemaRoot.getVector(0), (int)i, (Object)this.getValue(vector, customFieldVector, i, resolver));
        }
        outputSchemaRoot.getVector(0).setValueCount(valueCount);
        if (!inputSchemaRoot.equals(outputSchemaRoot)) {
            logger.error("DID NOT MATCH\nInput Schema:\n\t" + inputSchemaRoot.getSchema().toString() + "\nOutput Schema:\n\t" + outputSchemaRoot.getSchema().toString() + "\nInput FieldVectors:\n\t" + inputSchemaRoot.getFieldVectors().toString() + "\nOutput FieldVectors:\n\t" + outputSchemaRoot.getFieldVectors().toString() + "\n");
            return false;
        }
        logger.debug("Matched for Schema:\n\t" + inputSchemaRoot.getSchema().toString() + "\nwith FieldVectors:\n\t" + inputSchemaRoot.getFieldVectors().toString() + "\n");
        return true;
    }
}

