/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.TimeZoneKey;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class TimeZoneKeyTest {
    private static final TimeZoneKey PLUS_7_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)420L);
    private static final TimeZoneKey MINUS_7_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)-420L);

    @Test
    public void testUTC() {
        Assert.assertEquals((long)TimeZoneKey.UTC_KEY.getKey(), (long)0L);
        Assert.assertEquals((Object)TimeZoneKey.UTC_KEY.getId(), (Object)"UTC");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((short)0), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Z"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Zulu"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"zulu"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"ZULU"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UCT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Universal"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"+00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"-00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/utc"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/gmt"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/gmt+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/gmt+00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/gmt-00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/ut"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/UT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/UCT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"etc/Universal"), (Object)TimeZoneKey.UTC_KEY);
    }

    @Test
    public void testHourOffsetZone() {
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("GMT7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-7"), (Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("UT0");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("UT7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT-7"), (Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("UTC0");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("UTC7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/GMT7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-7"), (Object)PLUS_7_KEY);
        this.assertTimeZoneNotSupported("Etc/UT0");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/UT7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-7"), (Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("Etc/UTC0");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/UTC7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7"), (Object)MINUS_7_KEY);
    }

    @Test
    public void testZoneKeyLookup() {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((short)timeZoneKey.getKey()), (Object)timeZoneKey);
            Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)timeZoneKey.getId()), (Object)timeZoneKey);
            Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)timeZoneKey.getId().toUpperCase(Locale.ENGLISH)), (Object)timeZoneKey);
            Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)timeZoneKey.getId().toLowerCase(Locale.ENGLISH)), (Object)timeZoneKey);
        }
    }

    @Test
    public void testMaxTimeZoneKey() {
        boolean foundMax = false;
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            Assert.assertTrue((String)(timeZoneKey + " key is larger than max key " + TimeZoneKey.MAX_TIME_ZONE_KEY), (timeZoneKey.getKey() <= TimeZoneKey.MAX_TIME_ZONE_KEY ? 1 : 0) != 0);
            foundMax = foundMax || timeZoneKey.getKey() == TimeZoneKey.MAX_TIME_ZONE_KEY;
        }
        Assert.assertTrue((String)"Did not find a time zone with the MAX_TIME_ZONE_KEY", (boolean)foundMax);
    }

    @Test
    public void testZoneKeyIdRange() {
        boolean[] hasValue = new boolean[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            short key = timeZoneKey.getKey();
            Assert.assertTrue((String)(timeZoneKey + " has a negative time zone key"), (key >= 0 ? 1 : 0) != 0);
            Assert.assertFalse((String)("Another time zone has the same zone key as " + timeZoneKey), (boolean)hasValue[key]);
            hasValue[key] = true;
        }
        Assert.assertFalse((boolean)hasValue[2040]);
        hasValue[2040] = true;
        Assert.assertFalse((boolean)hasValue[2180]);
        hasValue[2180] = true;
        Assert.assertFalse((boolean)hasValue[2186]);
        hasValue[2186] = true;
        Assert.assertFalse((boolean)hasValue[2196]);
        hasValue[2196] = true;
        for (int i = 0; i < hasValue.length; ++i) {
            Assert.assertTrue((String)("There is no time zone with key " + i), (boolean)hasValue[i]);
        }
    }

    @Test
    public void testZoneKeyData() {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        ImmutableSortedSet timeZoneKeysSortedByKey = ImmutableSortedSet.copyOf((Comparator)new Comparator<TimeZoneKey>(){

            @Override
            public int compare(TimeZoneKey left, TimeZoneKey right) {
                return Short.compare(left.getKey(), right.getKey());
            }
        }, (Collection)TimeZoneKey.getTimeZoneKeys());
        for (TimeZoneKey timeZoneKey : timeZoneKeysSortedByKey) {
            hasher.putShort(timeZoneKey.getKey());
            hasher.putString((CharSequence)timeZoneKey.getId(), StandardCharsets.UTF_8);
        }
        Assert.assertEquals((String)"zone-index.properties file contents changed!", (long)hasher.hash().asLong(), (long)-4582158485614614451L);
    }

    public void assertTimeZoneNotSupported(String zoneId) {
        try {
            TimeZoneKey.getTimeZoneKey((String)zoneId);
            Assert.fail((String)"expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

