/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.helpers;

import com.amazonaws.athena.connector.lambda.data.helpers.CustomFieldVector;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import net.jqwik.api.Arbitraries;
import net.jqwik.time.api.Dates;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.holders.NullableDateDayHolder;
import org.apache.arrow.vector.holders.NullableDateMilliHolder;
import org.apache.arrow.vector.holders.NullableDecimalHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableSmallIntHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampSecTZHolder;
import org.apache.arrow.vector.holders.NullableTinyIntHolder;
import org.apache.arrow.vector.holders.NullableUInt1Holder;
import org.apache.arrow.vector.holders.NullableUInt2Holder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.holders.NullableUInt8Holder;
import org.apache.arrow.vector.holders.NullableVarBinaryHolder;
import org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Field;
import org.assertj.core.api.Assertions;

public class ValuesGenerator {
    private static final Long MIN_TIME = Instant.ofEpochMilli(Long.MIN_VALUE).toEpochMilli();
    private static final Long MAX_TIME = Instant.ofEpochMilli(Long.MAX_VALUE).toEpochMilli();

    public FieldVector generateValues(Field field, FieldVector vector, CustomFieldVector customVector) {
        this.generateValues(field, vector, customVector, 0, false);
        return vector;
    }

    public int generateValues(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        switch (vector.getMinorType()) {
            case BIGINT: {
                return this.setBigInt(field, vector, customVector, length, unique);
            }
            case BIT: {
                return this.setBit(field, vector, customVector, length, unique);
            }
            case DATEDAY: {
                return this.setDateDay(field, vector, customVector, length, unique);
            }
            case DATEMILLI: {
                return this.setDateMilli(field, vector, customVector, length, unique);
            }
            case DECIMAL: {
                return this.setDecimal(field, vector, customVector, length, unique);
            }
            case FLOAT4: {
                return this.setFloat4(field, vector, customVector, length, unique);
            }
            case FLOAT8: {
                return this.setFloat8(field, vector, customVector, length, unique);
            }
            case INT: {
                return this.setInt(field, vector, customVector, length, unique);
            }
            case LIST: {
                return this.setList(field, vector, customVector, length, unique);
            }
            case MAP: {
                return this.setMap(field, vector, customVector, length, unique);
            }
            case SMALLINT: {
                return this.setSmallInt(field, vector, customVector, length, unique);
            }
            case STRUCT: {
                return this.setStruct(field, vector, customVector, length, unique);
            }
            case TIMESTAMPMICROTZ: {
                return this.setTimestampMicroTz(field, vector, customVector, length, unique);
            }
            case TIMESTAMPMILLITZ: {
                return this.setTimestampMilliTz(field, vector, customVector, length, unique);
            }
            case TIMESTAMPNANOTZ: {
                return this.setTimestampNanoTz(field, vector, customVector, length, unique);
            }
            case TIMESTAMPSECTZ: {
                return this.setTimestampSecTz(field, vector, customVector, length, unique);
            }
            case TINYINT: {
                return this.setTinyInt(field, vector, customVector, length, unique);
            }
            case UINT1: {
                return this.setUint1(field, vector, customVector, length, unique);
            }
            case UINT2: {
                return this.setUint2(field, vector, customVector, length, unique);
            }
            case UINT4: {
                return this.setUint4(field, vector, customVector, length, unique);
            }
            case UINT8: {
                return this.setUint8(field, vector, customVector, length, unique);
            }
            case VARBINARY: {
                return this.setVarBinary(field, vector, customVector, length, unique);
            }
            case VARCHAR: {
                return this.setVarChar(field, vector, customVector, length, unique);
            }
        }
        throw new RuntimeException("Not yet implemented for typeId " + vector.getMinorType());
    }

    private int getLength(int length) {
        if (length == 0) {
            length = (Integer)Arbitraries.integers().between(1, 5).sample();
        }
        return length;
    }

    private boolean isNull(Field field) {
        if (!field.isNullable()) {
            return false;
        }
        return (Integer)Arbitraries.integers().between(0, 5).sample() == 0;
    }

    private int setStruct(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int i;
        int position = vector.getValueCount();
        int maxChildSize = 0;
        for (i = 0; i < vector.getChildrenFromFields().size(); ++i) {
            Field childField = (Field)field.getChildren().get(i);
            FieldVector childVector = (FieldVector)vector.getChildrenFromFields().get(i);
            CustomFieldVector childCustomVector = new CustomFieldVector(childField);
            maxChildSize = Math.max(this.generateValues(childField, childVector, childCustomVector, length, false), maxChildSize);
            customVector.add(childCustomVector);
        }
        for (i = position; i < maxChildSize; ++i) {
            ((StructVector)vector).setIndexDefined(i);
        }
        vector.setValueCount(maxChildSize);
        return vector.getValueCount();
    }

    private int setList(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        Assertions.assertThat((int)vector.getChildrenFromFields().size()).isEqualTo(1);
        int position = vector.getValueCount();
        Field childField = (Field)field.getChildren().get(0);
        FieldVector childVector = (FieldVector)vector.getChildrenFromFields().get(0);
        length = this.getLength(length);
        int prevChildSize = childVector.getValueCount();
        for (int i = 0; i < length; ++i) {
            CustomFieldVector childCustomVector = null;
            if (!this.isNull(field)) {
                childCustomVector = new CustomFieldVector(childField);
                ((ListVector)vector).startNewValue(position + i);
                int newChildSize = this.generateValues(childField, childVector, childCustomVector, 0, false);
                ((ListVector)vector).endValue(position + i, newChildSize - prevChildSize);
                prevChildSize = newChildSize;
            }
            customVector.add(childCustomVector);
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setMap(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int i;
        Assertions.assertThat((int)vector.getChildrenFromFields().size()).isEqualTo(1);
        int position = vector.getValueCount();
        Field entriesField = (Field)field.getChildren().get(0);
        FieldVector entries = (FieldVector)vector.getChildrenFromFields().get(0);
        Assertions.assertThat((int)entries.getChildrenFromFields().size()).isEqualTo(2);
        Field keysField = (Field)entriesField.getChildren().get(0);
        FieldVector keys = (FieldVector)entries.getChildrenFromFields().get(0);
        Field valuesField = (Field)entriesField.getChildren().get(1);
        FieldVector values = (FieldVector)entries.getChildrenFromFields().get(1);
        length = this.getLength(length);
        for (i = 0; i < length; ++i) {
            ((MapVector)vector).startNewValue(position + i);
            int keysValuesLength = this.getLength(0);
            if (keys.getMinorType().equals((Object)Types.MinorType.VARBINARY) || keys.getMinorType().equals((Object)Types.MinorType.BIT)) {
                keysValuesLength = 2;
            }
            CustomFieldVector keysCustomVector = new CustomFieldVector(keysField);
            CustomFieldVector valuesCustomVector = new CustomFieldVector(valuesField);
            this.generateValues(keysField, keys, keysCustomVector, keysValuesLength, true);
            this.generateValues(valuesField, values, valuesCustomVector, keysValuesLength, false);
            customVector.addMap(keysCustomVector, valuesCustomVector);
            ((MapVector)vector).endValue(position + i, keysValuesLength);
        }
        vector.setValueCount(position + length);
        for (i = 0; i < keys.getValueCount(); ++i) {
            ((StructVector)entries).setIndexDefined(i);
        }
        entries.setValueCount(keys.getValueCount());
        return vector.getValueCount();
    }

    private int setBigInt(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.longs().list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.longs().list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((BigIntVector)vector).setSafe(i + position, new NullableBigIntHolder());
            } else {
                ((BigIntVector)vector).setSafe(i + position, ((Long)items.get(i)).longValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setBit(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.integers().between(0, 1).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.integers().between(0, 1).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((BitVector)vector).setSafe(i + position, new NullableBitHolder());
            } else {
                ((BitVector)vector).setSafe(i + position, ((Integer)items.get(i)).intValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setDateDay(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Dates.dates().list().ofSize(length).uniqueElements().sample() : (List)Dates.dates().list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((DateDayVector)vector).setSafe(i + position, new NullableDateDayHolder());
            } else {
                ((DateDayVector)vector).setSafe(i + position, (int)((LocalDate)items.get(i)).toEpochDay());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setDateMilli(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((DateMilliVector)vector).setSafe(i + position, new NullableDateMilliHolder());
            } else {
                ((DateMilliVector)vector).setSafe(i + position, ((Long)items.get(i)).longValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setDecimal(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        int scale = ((DecimalVector)vector).getScale();
        int precision = ((DecimalVector)vector).getPrecision();
        double range = Math.pow(10.0, precision - scale);
        List items = unique ? (List)Arbitraries.bigDecimals().greaterThan(new BigDecimal(range * -1.0)).lessThan(new BigDecimal(range)).ofScale(scale).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.bigDecimals().greaterThan(new BigDecimal(range * -1.0)).lessThan(new BigDecimal(range)).ofScale(scale).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((DecimalVector)vector).setSafe(i + position, new NullableDecimalHolder());
            } else {
                ((DecimalVector)vector).setSafe(i + position, (BigDecimal)items.get(i));
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setFloat4(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.floats().list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.floats().list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((Float4Vector)vector).setSafe(i + position, new NullableFloat4Holder());
            } else {
                ((Float4Vector)vector).setSafe(i + position, ((Float)items.get(i)).floatValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setFloat8(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.floats().list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.floats().list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((Float8Vector)vector).setSafe(i + position, new NullableFloat8Holder());
            } else {
                ((Float8Vector)vector).setSafe(i + position, (double)((Float)items.get(i)).floatValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    protected int setInt(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.integers().list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.integers().list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((IntVector)vector).setSafe(i + position, new NullableIntHolder());
            } else {
                ((IntVector)vector).setSafe(i + position, ((Integer)items.get(i)).intValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setSmallInt(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.shorts().list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.shorts().list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((SmallIntVector)vector).setSafe(i + position, new NullableSmallIntHolder());
            } else {
                ((SmallIntVector)vector).setSafe(i + position, ((Short)items.get(i)).shortValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setTimestampMicroTz(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((TimeStampMicroTZVector)vector).setSafe(i + position, new NullableTimeStampMicroTZHolder());
            } else {
                ((TimeStampMicroTZVector)vector).setSafe(i + position, ((Long)items.get(i)).longValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setTimestampMilliTz(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((TimeStampMilliTZVector)vector).setSafe(i + position, new NullableTimeStampMilliTZHolder());
            } else {
                ((TimeStampMilliTZVector)vector).setSafe(i + position, ((Long)items.get(i)).longValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setTimestampNanoTz(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((TimeStampNanoTZVector)vector).setSafe(i + position, new NullableTimeStampNanoTZHolder());
            } else {
                ((TimeStampNanoTZVector)vector).setSafe(i + position, ((Long)items.get(i)).longValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setTimestampSecTz(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.longs().greaterOrEqual(MIN_TIME.longValue()).lessOrEqual(MAX_TIME.longValue()).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((TimeStampSecTZVector)vector).setSafe(i + position, new NullableTimeStampSecTZHolder());
            } else {
                ((TimeStampSecTZVector)vector).setSafe(i + position, ((Long)items.get(i)).longValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setTinyInt(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.bytes().list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.bytes().list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((TinyIntVector)vector).setSafe(i + position, new NullableTinyIntHolder());
            } else {
                ((TinyIntVector)vector).setSafe(i + position, ((Byte)items.get(i)).byteValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setVarChar(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.strings().ofMinLength(1).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.strings().ofMinLength(1).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((VarCharVector)vector).setSafe(i + position, new NullableVarCharHolder());
            } else {
                ((VarCharVector)vector).setSafe(i + position, ((String)items.get(i)).getBytes(StandardCharsets.UTF_8));
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setUint1(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.bytes().greaterOrEqual((byte)0).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.bytes().greaterOrEqual((byte)0).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((UInt1Vector)vector).setSafe(i + position, new NullableUInt1Holder());
            } else {
                ((UInt1Vector)vector).setSafe(i + position, ((Byte)items.get(i)).byteValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setUint2(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.shorts().greaterOrEqual((short)0).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.shorts().greaterOrEqual((short)0).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((UInt2Vector)vector).setSafe(i + position, new NullableUInt2Holder());
            } else {
                ((UInt2Vector)vector).setSafe(i + position, (int)((Short)items.get(i)).shortValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setUint4(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.integers().greaterOrEqual(0).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.integers().greaterOrEqual(0).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((UInt4Vector)vector).setSafe(i + position, new NullableUInt4Holder());
            } else {
                ((UInt4Vector)vector).setSafe(i + position, ((Integer)items.get(i)).intValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setUint8(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.longs().greaterOrEqual(0L).list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.longs().greaterOrEqual(0L).list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((UInt8Vector)vector).setSafe(i + position, new NullableUInt8Holder());
            } else {
                ((UInt8Vector)vector).setSafe(i + position, ((Long)items.get(i)).longValue());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }

    private int setVarBinary(Field field, FieldVector vector, CustomFieldVector customVector, int length, boolean unique) {
        int position = vector.getValueCount();
        length = this.getLength(length);
        List items = unique ? (List)Arbitraries.strings().list().ofSize(length).uniqueElements().sample() : (List)Arbitraries.strings().list().ofSize(length).sample();
        for (int i = 0; i < length; ++i) {
            if (this.isNull(field)) {
                ((VarBinaryVector)vector).setSafe(i + position, new NullableVarBinaryHolder());
            } else {
                ((VarBinaryVector)vector).setSafe(i + position, ((String)items.get(i)).getBytes());
            }
            customVector.add(vector.getObject(i + position));
        }
        vector.setValueCount(position + length);
        return vector.getValueCount();
    }
}

