/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.domain.predicate.AllOrNoneValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AllOrNoneValueSetTest {
    private BlockAllocatorImpl allocator;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void testAll() throws Exception {
        AllOrNoneValueSet valueSet = AllOrNoneValueSet.all((ArrowType)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)valueSet.getType(), (Object)Types.MinorType.INT.getType());
        Assert.assertFalse((boolean)valueSet.isNone());
        Assert.assertTrue((boolean)valueSet.isAll());
        Assert.assertFalse((boolean)valueSet.isSingleValue());
        Assert.assertTrue((boolean)valueSet.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)0)));
        try {
            valueSet.getSingleValue();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNullability() throws Exception {
        AllOrNoneValueSet notNull = AllOrNoneValueSet.notNull((ArrowType)Types.MinorType.INT.getType());
        Assert.assertTrue((boolean)notNull.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)100)));
        Assert.assertFalse((boolean)notNull.containsValue(Marker.nullMarker((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType())));
        Assert.assertTrue((boolean)notNull.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)101)));
        AllOrNoneValueSet onlyNull = AllOrNoneValueSet.onlyNull((ArrowType)Types.MinorType.INT.getType());
        Assert.assertFalse((boolean)onlyNull.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)100)));
        Assert.assertTrue((boolean)onlyNull.containsValue(Marker.nullMarker((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType())));
        Assert.assertFalse((boolean)onlyNull.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)101)));
    }

    @Test
    public void testNone() throws Exception {
        AllOrNoneValueSet valueSet = AllOrNoneValueSet.none((ArrowType)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)valueSet.getType(), (Object)Types.MinorType.INT.getType());
        Assert.assertTrue((boolean)valueSet.isNone());
        Assert.assertFalse((boolean)valueSet.isAll());
        Assert.assertFalse((boolean)valueSet.isSingleValue());
        Assert.assertFalse((boolean)valueSet.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)0)));
        try {
            valueSet.getSingleValue();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIntersect() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((ArrowType)Types.MinorType.INT.getType());
        AllOrNoneValueSet none = AllOrNoneValueSet.none((ArrowType)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)all.intersect((BlockAllocator)this.allocator, (ValueSet)all), (Object)all);
        Assert.assertEquals((Object)all.intersect((BlockAllocator)this.allocator, (ValueSet)none), (Object)none);
        Assert.assertEquals((Object)none.intersect((BlockAllocator)this.allocator, (ValueSet)all), (Object)none);
        Assert.assertEquals((Object)none.intersect((BlockAllocator)this.allocator, (ValueSet)none), (Object)none);
    }

    @Test
    public void testUnion() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((ArrowType)Types.MinorType.INT.getType());
        AllOrNoneValueSet none = AllOrNoneValueSet.none((ArrowType)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)all.union((BlockAllocator)this.allocator, (ValueSet)all), (Object)all);
        Assert.assertEquals((Object)all.union((BlockAllocator)this.allocator, (ValueSet)none), (Object)all);
        Assert.assertEquals((Object)none.union((BlockAllocator)this.allocator, (ValueSet)all), (Object)all);
        Assert.assertEquals((Object)none.union((BlockAllocator)this.allocator, (ValueSet)none), (Object)none);
    }

    @Test
    public void testComplement() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((ArrowType)Types.MinorType.INT.getType());
        AllOrNoneValueSet none = AllOrNoneValueSet.none((ArrowType)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)all.complement((BlockAllocator)this.allocator), (Object)none);
        Assert.assertEquals((Object)none.complement((BlockAllocator)this.allocator), (Object)all);
    }

    @Test
    public void testOverlaps() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((ArrowType)Types.MinorType.INT.getType());
        AllOrNoneValueSet none = AllOrNoneValueSet.none((ArrowType)Types.MinorType.INT.getType());
        Assert.assertTrue((boolean)all.overlaps((BlockAllocator)this.allocator, (ValueSet)all));
        Assert.assertFalse((boolean)all.overlaps((BlockAllocator)this.allocator, (ValueSet)none));
        Assert.assertFalse((boolean)none.overlaps((BlockAllocator)this.allocator, (ValueSet)all));
        Assert.assertFalse((boolean)none.overlaps((BlockAllocator)this.allocator, (ValueSet)none));
    }

    @Test
    public void testSubtract() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((ArrowType)Types.MinorType.INT.getType());
        AllOrNoneValueSet none = AllOrNoneValueSet.none((ArrowType)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)all.subtract((BlockAllocator)this.allocator, (ValueSet)all), (Object)none);
        Assert.assertEquals((Object)all.subtract((BlockAllocator)this.allocator, (ValueSet)none), (Object)all);
        Assert.assertEquals((Object)none.subtract((BlockAllocator)this.allocator, (ValueSet)all), (Object)none);
        Assert.assertEquals((Object)none.subtract((BlockAllocator)this.allocator, (ValueSet)none), (Object)none);
    }

    @Test
    public void testContains() throws Exception {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((ArrowType)Types.MinorType.INT.getType());
        AllOrNoneValueSet none = AllOrNoneValueSet.none((ArrowType)Types.MinorType.INT.getType());
        Assert.assertTrue((boolean)all.contains((BlockAllocator)this.allocator, (ValueSet)all));
        Assert.assertTrue((boolean)all.contains((BlockAllocator)this.allocator, (ValueSet)none));
        Assert.assertFalse((boolean)none.contains((BlockAllocator)this.allocator, (ValueSet)all));
        Assert.assertTrue((boolean)none.contains((BlockAllocator)this.allocator, (ValueSet)none));
    }
}

