/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.domain.predicate.SortedRangeSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SortedRangeSetTest {
    private BlockAllocatorImpl allocator;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void testEmptySet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType());
        Assert.assertEquals((Object)rangeSet.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertTrue((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)rangeSet.getOrderedRanges()));
        Assert.assertEquals((long)rangeSet.getRangeCount(), (long)0L);
        Assert.assertEquals((Object)rangeSet.complement((BlockAllocator)this.allocator), (Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testEntireSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType());
        Assert.assertEquals((Object)rangeSet.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertTrue((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertEquals((long)rangeSet.getRangeCount(), (long)1L);
        Assert.assertEquals((Object)rangeSet.complement((BlockAllocator)this.allocator), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testNullability() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (boolean)true, (Object)10L, Collections.singletonList(10L));
        Assert.assertTrue((boolean)rangeSet.containsValue(Marker.nullMarker((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)rangeSet.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)rangeSet.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L)));
    }

    @Test
    public void testSingleValue() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L, (Object[])new Object[0]);
        SortedRangeSet complement = SortedRangeSet.of((boolean)true, (Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L), (Range[])new Range[]{Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertTrue((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)ImmutableList.of((Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L))));
        Assert.assertEquals((long)rangeSet.getRangeCount(), (long)1L);
        Assert.assertEquals((Object)rangeSet.complement((BlockAllocator)this.allocator), (Object)complement);
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)9L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testBoundedSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)9L, (boolean)true, (Object)11L, (boolean)false), Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L, (boolean)true, (Object)4L, (boolean)true), Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)4L, (boolean)false, (Object)5L, (boolean)true)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L, (boolean)true, (Object)5L, (boolean)true), (Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)9L, (boolean)true, (Object)11L, (boolean)false));
        SortedRangeSet complement = SortedRangeSet.of((boolean)true, (Range)Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)5L, (boolean)false, (Object)9L, (boolean)false), Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)11L)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)normalizedResult));
        Assert.assertEquals((Object)rangeSet, (Object)SortedRangeSet.copyOf((ArrowType)Types.MinorType.BIGINT.getType(), (List)normalizedResult, (boolean)false));
        Assert.assertEquals((long)rangeSet.getRangeCount(), (long)3L);
        Assert.assertEquals((Object)rangeSet.complement((BlockAllocator)this.allocator), (Object)complement);
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)7L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)9L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testUnboundedSet() throws Exception {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L), (Range[])new Range[]{Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L, (boolean)true, (Object)4L, (boolean)false), Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)4L, (boolean)true, (Object)6L, (boolean)false), Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)false, (Object)2L, (boolean)false), Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)9L, (boolean)false, (Object)11L, (boolean)false)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)false, (Object)6L, (boolean)false), (Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)9L));
        SortedRangeSet complement = SortedRangeSet.of((boolean)true, (Range)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[]{Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)6L, (boolean)true, (Object)9L, (boolean)true)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)normalizedResult));
        Assert.assertEquals((Object)rangeSet, (Object)SortedRangeSet.copyOf((ArrowType)Types.MinorType.BIGINT.getType(), (List)normalizedResult, (boolean)false));
        Assert.assertEquals((long)rangeSet.getRangeCount(), (long)3L);
        Assert.assertEquals((Object)rangeSet.complement((BlockAllocator)this.allocator), (Object)complement);
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)4L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)7L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testGetSingleValue() throws Exception {
        Assert.assertEquals((Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).getSingleValue(), (Object)0L);
        try {
            SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSpan() throws Exception {
        try {
            SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).getSpan();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).getSpan(), (Object)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).getSpan(), (Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).getSpan(), (Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)true, (Object)1L, (boolean)true));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).getSpan(), (Object)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).getSpan(), (Object)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).overlaps((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).contains((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])));
    }

    @Test
    public void testIntersect() throws Exception {
        Assert.assertEquals((Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).intersect((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).intersect((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).intersect((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L)}).intersect((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)4L)})), (Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).intersect((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)4L)})), (Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)4L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]).intersect((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), (Range[])new Range[]{Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L)})), (Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), (Range[])new Range[]{Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L, (boolean)false, (Object)4L, (boolean)false)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).intersect((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)-1L), (Range[])new Range[0]).intersect((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)-1L, (boolean)true, (Object)1L, (boolean)true), (Range[])new Range[0]));
    }

    @Test
    public void testUnion() throws Exception {
        this.assertUnion(SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()), SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()), SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        this.assertUnion(SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()), SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()), SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        this.assertUnion(SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()), SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()), SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        this.assertUnion(SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)}), SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L)}), SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L), Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L)}));
        this.assertUnion(SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()), SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]), SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        this.assertUnion(SortedRangeSet.of((Range)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((boolean)true, (Range)Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).complement((BlockAllocator)this.allocator));
    }

    @Test
    public void testSubtract() throws Exception {
        Assert.assertEquals((Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})), (Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((boolean)true, (Range)Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType())), (Object)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[]{Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)})), (Object)SortedRangeSet.of((Range)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)false, (Object)1L, (boolean)false), (Range[])new Range[]{Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0]).subtract((BlockAllocator)this.allocator, (ValueSet)SortedRangeSet.of((Range)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.none((ArrowType)Types.MinorType.BIGINT.getType()));
    }

    private void assertUnion(SortedRangeSet first, SortedRangeSet second, SortedRangeSet expected) {
        Assert.assertEquals((Object)first.union((BlockAllocator)this.allocator, (ValueSet)second), (Object)expected);
        Assert.assertEquals((Object)first.union((BlockAllocator)this.allocator, (Collection)ImmutableList.of((Object)first, (Object)second)), (Object)expected);
    }
}

