/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.handlers;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.spill.S3SpillLocation;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocationVerifier;
import com.amazonaws.athena.connector.lambda.handlers.CompositeHandler;
import com.amazonaws.athena.connector.lambda.handlers.MetadataHandler;
import com.amazonaws.athena.connector.lambda.handlers.RecordHandler;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesResponse;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsRequest;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsResponse;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.PingRequest;
import com.amazonaws.athena.connector.lambda.request.PingResponse;
import com.amazonaws.athena.connector.lambda.security.IdentityUtil;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeHandlerTest {
    private static final Logger logger = LoggerFactory.getLogger(CompositeHandlerTest.class);
    private MetadataHandler mockMetadataHandler;
    private RecordHandler mockRecordHandler;
    private CompositeHandler compositeHandler;
    private BlockAllocatorImpl allocator;
    private ObjectMapper objectMapper;
    private Schema schemaForRead;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        logger.info("{}: enter", (Object)this.testName.getMethodName());
        this.allocator = new BlockAllocatorImpl();
        this.objectMapper = ObjectMapperFactory.create((BlockAllocator)this.allocator);
        this.mockMetadataHandler = (MetadataHandler)Mockito.mock(MetadataHandler.class);
        this.mockRecordHandler = (RecordHandler)Mockito.mock(RecordHandler.class);
        this.schemaForRead = SchemaBuilder.newBuilder().addField("col1", (ArrowType)new ArrowType.Int(32, true)).build();
        Mockito.when((Object)this.mockMetadataHandler.doGetTableLayout((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (GetTableLayoutRequest)Matchers.any(GetTableLayoutRequest.class))).thenReturn((Object)new GetTableLayoutResponse("catalog", new TableName("schema", "table"), BlockUtils.newBlock((BlockAllocator)this.allocator, (String)"col1", (ArrowType)Types.MinorType.BIGINT.getType(), (Object[])new Object[]{1L})));
        Mockito.when((Object)this.mockMetadataHandler.doListTables((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (ListTablesRequest)Matchers.any(ListTablesRequest.class))).thenReturn((Object)new ListTablesResponse("catalog", Collections.singletonList(new TableName("schema", "table")), null));
        Mockito.when((Object)this.mockMetadataHandler.doGetTable((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (GetTableRequest)Matchers.any(GetTableRequest.class))).thenReturn((Object)new GetTableResponse("catalog", new TableName("schema", "table"), SchemaBuilder.newBuilder().addStringField("col1").build()));
        Mockito.when((Object)this.mockMetadataHandler.doListSchemaNames((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (ListSchemasRequest)Matchers.any(ListSchemasRequest.class))).thenReturn((Object)new ListSchemasResponse("catalog", Collections.singleton("schema1")));
        Mockito.when((Object)this.mockMetadataHandler.doGetSplits((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (GetSplitsRequest)Matchers.any(GetSplitsRequest.class))).thenReturn((Object)new GetSplitsResponse("catalog", Split.newBuilder(null, null).build()));
        Mockito.when((Object)this.mockMetadataHandler.doPing((PingRequest)Matchers.any(PingRequest.class))).thenReturn((Object)new PingResponse("catalog", "queryId", "type", 23, 2));
        Mockito.when((Object)this.mockRecordHandler.doReadRecords((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (ReadRecordsRequest)Matchers.any(ReadRecordsRequest.class))).thenReturn((Object)new ReadRecordsResponse("catalog", BlockUtils.newEmptyBlock((BlockAllocator)this.allocator, (String)"col", (ArrowType)new ArrowType.Int(32, true))));
        this.compositeHandler = new CompositeHandler(this.mockMetadataHandler, this.mockRecordHandler);
    }

    @After
    public void after() {
        this.allocator.close();
        logger.info("{}: exit ", (Object)this.testName.getMethodName());
    }

    @Test
    public void doReadRecords() throws Exception {
        ReadRecordsRequest req = new ReadRecordsRequest(IdentityUtil.fakeIdentity(), "catalog", "queryId-" + System.currentTimeMillis(), new TableName("schema", "table"), this.schemaForRead, Split.newBuilder((SpillLocation)S3SpillLocation.newBuilder().withBucket("athena-virtuoso-test").withPrefix("lambda-spill").withQueryId(UUID.randomUUID().toString()).withSplitId(UUID.randomUUID().toString()).withIsDirectory(true).build(), null).build(), new Constraints(new HashMap()), 100000000000L, 100000000000L);
        this.compositeHandler.handleRequest((BlockAllocator)this.allocator, (FederationRequest)req, (OutputStream)new ByteArrayOutputStream(), this.objectMapper);
        ((RecordHandler)Mockito.verify((Object)this.mockRecordHandler, (VerificationMode)Mockito.times((int)1))).doReadRecords((BlockAllocator)Matchers.any(BlockAllocator.class), (ReadRecordsRequest)Matchers.any(ReadRecordsRequest.class));
    }

    @Test
    public void doListSchemaNames() throws Exception {
        ListSchemasRequest req = (ListSchemasRequest)Mockito.mock(ListSchemasRequest.class);
        Mockito.when((Object)req.getRequestType()).thenReturn((Object)MetadataRequestType.LIST_SCHEMAS);
        this.compositeHandler.handleRequest((BlockAllocator)this.allocator, (FederationRequest)req, (OutputStream)new ByteArrayOutputStream(), this.objectMapper);
        ((MetadataHandler)Mockito.verify((Object)this.mockMetadataHandler, (VerificationMode)Mockito.times((int)1))).doListSchemaNames((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (ListSchemasRequest)Matchers.any(ListSchemasRequest.class));
    }

    @Test
    public void doListTables() throws Exception {
        ListTablesRequest req = (ListTablesRequest)Mockito.mock(ListTablesRequest.class);
        Mockito.when((Object)req.getRequestType()).thenReturn((Object)MetadataRequestType.LIST_TABLES);
        this.compositeHandler.handleRequest((BlockAllocator)this.allocator, (FederationRequest)req, (OutputStream)new ByteArrayOutputStream(), this.objectMapper);
        ((MetadataHandler)Mockito.verify((Object)this.mockMetadataHandler, (VerificationMode)Mockito.times((int)1))).doListTables((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (ListTablesRequest)Matchers.any(ListTablesRequest.class));
    }

    @Test
    public void doGetTable() throws Exception {
        GetTableRequest req = (GetTableRequest)Mockito.mock(GetTableRequest.class);
        Mockito.when((Object)req.getRequestType()).thenReturn((Object)MetadataRequestType.GET_TABLE);
        this.compositeHandler.handleRequest((BlockAllocator)this.allocator, (FederationRequest)req, (OutputStream)new ByteArrayOutputStream(), this.objectMapper);
        ((MetadataHandler)Mockito.verify((Object)this.mockMetadataHandler, (VerificationMode)Mockito.times((int)1))).doGetTable((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (GetTableRequest)Matchers.any(GetTableRequest.class));
    }

    @Test
    public void doGetTableLayout() throws Exception {
        GetTableLayoutRequest req = (GetTableLayoutRequest)Mockito.mock(GetTableLayoutRequest.class);
        Mockito.when((Object)req.getRequestType()).thenReturn((Object)MetadataRequestType.GET_TABLE_LAYOUT);
        this.compositeHandler.handleRequest((BlockAllocator)this.allocator, (FederationRequest)req, (OutputStream)new ByteArrayOutputStream(), this.objectMapper);
        ((MetadataHandler)Mockito.verify((Object)this.mockMetadataHandler, (VerificationMode)Mockito.times((int)1))).doGetTableLayout((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (GetTableLayoutRequest)Matchers.any(GetTableLayoutRequest.class));
    }

    @Test
    public void doGetSplits() throws Exception {
        GetSplitsRequest req = (GetSplitsRequest)Mockito.mock(GetSplitsRequest.class);
        Mockito.when((Object)req.getRequestType()).thenReturn((Object)MetadataRequestType.GET_SPLITS);
        SpillLocationVerifier mockVerifier = (SpillLocationVerifier)Mockito.mock(SpillLocationVerifier.class);
        ((SpillLocationVerifier)Mockito.doNothing().when((Object)mockVerifier)).checkBucketAuthZ((String)Matchers.any(String.class));
        Whitebox.setInternalState((Object)this.mockMetadataHandler, (String)"verifier", (Object)mockVerifier);
        this.compositeHandler.handleRequest((BlockAllocator)this.allocator, (FederationRequest)req, (OutputStream)new ByteArrayOutputStream(), this.objectMapper);
        ((MetadataHandler)Mockito.verify((Object)this.mockMetadataHandler, (VerificationMode)Mockito.times((int)1))).doGetSplits((BlockAllocator)Matchers.any(BlockAllocatorImpl.class), (GetSplitsRequest)Matchers.any(GetSplitsRequest.class));
    }

    @Test
    public void doPing() throws Exception {
        PingRequest req = (PingRequest)Mockito.mock(PingRequest.class);
        Mockito.when((Object)req.getCatalogName()).thenReturn((Object)"catalog");
        Mockito.when((Object)req.getQueryId()).thenReturn((Object)"queryId");
        this.compositeHandler.handleRequest((BlockAllocator)this.allocator, (FederationRequest)req, (OutputStream)new ByteArrayOutputStream(), this.objectMapper);
        ((MetadataHandler)Mockito.verify((Object)this.mockMetadataHandler, (VerificationMode)Mockito.times((int)1))).doPing((PingRequest)Matchers.any(PingRequest.class));
    }
}

