/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.data.SchemaSerDe;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperFactory;
import com.amazonaws.athena.connector.lambda.serde.TestPojo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSerializationTest {
    private static final Logger logger = LoggerFactory.getLogger(SchemaSerializationTest.class);
    private final ObjectMapper objectMapper = ObjectMapperFactory.create((BlockAllocator)new BlockAllocatorImpl());

    @Test
    public void serializationTest() throws IOException {
        logger.info("serializationTest - enter");
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addMetadata("meta1", "meta-value-1");
        schemaBuilder.addMetadata("meta2", "meta-value-2");
        schemaBuilder.addField("intfield1", (ArrowType)new ArrowType.Int(32, true));
        schemaBuilder.addField("doublefield2", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
        schemaBuilder.addField("varcharfield3", (ArrowType)new ArrowType.Utf8());
        Schema expectedSchema = schemaBuilder.build();
        SchemaSerDe serDe = new SchemaSerDe();
        ByteArrayOutputStream schemaOut = new ByteArrayOutputStream();
        serDe.serialize(expectedSchema, (OutputStream)schemaOut);
        TestPojo expected = new TestPojo(expectedSchema);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.objectMapper.writeValue((OutputStream)out, (Object)expected);
        TestPojo actual = (TestPojo)this.objectMapper.readValue((InputStream)new ByteArrayInputStream(out.toByteArray()), TestPojo.class);
        Schema actualSchema = actual.getSchema();
        logger.info("serializationTest - fields[{}]", (Object)actualSchema.getFields());
        logger.info("serializationTest - meta[{}]", (Object)actualSchema.getCustomMetadata());
        Assert.assertEquals((Object)expectedSchema.getFields(), (Object)actualSchema.getFields());
        Assert.assertEquals((Object)expectedSchema.getCustomMetadata(), (Object)actualSchema.getCustomMetadata());
        logger.info("serializationTest - exit");
    }
}

