/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.AllOrNoneValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.EquatableValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.domain.predicate.SortedRangeSet;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.fasterxml.jackson.core.JsonEncoding;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTableLayoutRequestSerDeTest
extends TypedSerDeTest<FederationRequest> {
    private static final Logger logger = LoggerFactory.getLogger(GetTableLayoutRequestSerDeTest.class);

    @Before
    public void beforeTest() throws IOException {
        Schema schema = SchemaBuilder.newBuilder().addField("year", (ArrowType)new ArrowType.Int(32, true)).addField("month", (ArrowType)new ArrowType.Int(32, true)).addField("day", (ArrowType)new ArrowType.Int(32, true)).addField("col2", (ArrowType)new ArrowType.Utf8()).addField("col3", Types.MinorType.FLOAT8.getType()).addField("col4", Types.MinorType.FLOAT8.getType()).addField("col5", Types.MinorType.FLOAT8.getType()).build();
        HashMap<String, Object> constraintsMap = new HashMap<String, Object>();
        constraintsMap.put("col3", SortedRangeSet.copyOf((ArrowType)Types.MinorType.FLOAT8.getType(), (List)ImmutableList.of((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.FLOAT8.getType(), (Object)-10000.0)), (boolean)false));
        constraintsMap.put("col4", EquatableValueSet.newBuilder((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.FLOAT8.getType(), (boolean)false, (boolean)true).add((Object)1.1).build());
        constraintsMap.put("col5", new AllOrNoneValueSet(Types.MinorType.FLOAT8.getType(), false, true));
        Constraints constraints = new Constraints(constraintsMap);
        this.expected = new GetTableLayoutRequest(this.federatedIdentity, "test-query-id", "test-catalog", new TableName("test-schema", "test-table"), constraints, schema, (Set)ImmutableSet.of((Object)"year", (Object)"month", (Object)"day"));
        String expectedSerDeFile = this.utils.getResourceOrFail("serde/v2", "GetTableLayoutRequest.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws Exception {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        ((FederationRequest)this.expected).close();
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        GetTableLayoutRequest actual = (GetTableLayoutRequest)this.mapper.readValue((InputStream)input, FederationRequest.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("deserialize: exit");
    }
}

