/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.serde.VersionedObjectMapperFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.Test;

public class ObjectMapperFactoryV2Test {
    @Test(expected=JsonMappingException.class)
    public void testStrictSerializer() throws JsonProcessingException {
        try (BlockAllocatorImpl allocator = new BlockAllocatorImpl();){
            ObjectMapper mapper = VersionedObjectMapperFactory.create((BlockAllocator)allocator, (int)2);
            mapper.writeValueAsString((Object)new ArrowType.Null());
        }
    }

    @Test(expected=JsonMappingException.class)
    public void testStrictDeserializer() throws IOException {
        try (BlockAllocatorImpl allocator = new BlockAllocatorImpl();){
            ObjectMapper mapper = VersionedObjectMapperFactory.create((BlockAllocator)allocator, (int)2);
            mapper.readValue("{\"@type\" : \"FloatingPoint\", \"precision\" : \"DOUBLE\"}", ArrowType.FloatingPoint.class);
        }
    }
}

