/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionRequest;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionType;
import com.fasterxml.jackson.core.JsonEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDefinedFunctionRequestSerDeTest
extends TypedSerDeTest<FederationRequest> {
    private static final Logger logger = LoggerFactory.getLogger(UserDefinedFunctionRequestSerDeTest.class);

    @Before
    public void beforeTest() throws IOException {
        Schema inputSchema = SchemaBuilder.newBuilder().addField("factor1", Types.MinorType.INT.getType()).addField("factor2", Types.MinorType.INT.getType()).build();
        Schema outputSchema = SchemaBuilder.newBuilder().addField("product", Types.MinorType.INT.getType()).build();
        Block inputRecords = this.allocator.createBlock(inputSchema);
        inputRecords.setRowCount(1);
        IntVector inputVector1 = (IntVector)inputRecords.getFieldVector("factor1");
        IntVector inputVector2 = (IntVector)inputRecords.getFieldVector("factor2");
        inputVector1.setSafe(0, 2);
        inputVector2.setSafe(0, 3);
        this.expected = new UserDefinedFunctionRequest(this.federatedIdentity, inputRecords, outputSchema, "test-method", UserDefinedFunctionType.SCALAR);
        String expectedSerDeFile = this.utils.getResourceOrFail("serde/v2", "UserDefinedFunctionRequest.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws Exception {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        ((FederationRequest)this.expected).close();
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        UserDefinedFunctionRequest actual = (UserDefinedFunctionRequest)this.mapper.readValue((InputStream)input, FederationRequest.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("deserialize: exit");
    }
}

