/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda;

import com.amazonaws.athena.connector.lambda.ThrottlingInvoker;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.amazonaws.services.athena.model.InvalidRequestException;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStatusChecker
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(QueryStatusChecker.class);
    private static final int[] FIBONACCI = new int[]{1, 1, 2, 3, 5, 8, 13, 21, 34, 55};
    private static final Set<String> TERMINAL_STATES = ImmutableSet.of((Object)"SUCCEEDED", (Object)"FAILED", (Object)"CANCELLED");
    private boolean wasStarted = false;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final AmazonAthena athena;
    private final ThrottlingInvoker athenaInvoker;
    private final String queryId;
    private final Thread checkerThread;

    public QueryStatusChecker(AmazonAthena athena, ThrottlingInvoker athenaInvoker, String queryId) {
        this.athena = athena;
        this.athenaInvoker = athenaInvoker;
        this.queryId = queryId;
        this.checkerThread = new Thread(() -> this.runQueryStatusChecker(queryId), "QueryStatusCheckerThread-" + queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueryRunning() {
        if (!this.wasStarted) {
            QueryStatusChecker queryStatusChecker = this;
            synchronized (queryStatusChecker) {
                if (!this.wasStarted) {
                    this.checkerThread.start();
                    this.wasStarted = true;
                }
            }
        }
        return this.isRunning.get();
    }

    @Override
    public void close() {
        this.checkerThread.interrupt();
        logger.debug("Interrupt signal sent to status checker thread");
    }

    private void runQueryStatusChecker(String queryId) {
        int attempt = 0;
        while (this.isRunning.get()) {
            int delay = FIBONACCI[Math.min(attempt, FIBONACCI.length - 1)];
            try {
                Thread.sleep(delay * 1000);
                this.checkStatus(queryId, attempt);
            }
            catch (InterruptedException e) {
                logger.debug("Checker thread interrupted. Ceasing status polling");
                return;
            }
            ++attempt;
        }
        logger.debug("Query terminated. Ceasing status polling");
    }

    private void checkStatus(String queryId, int attempt) throws InterruptedException {
        block3: {
            logger.debug(String.format("Background thread checking status of Athena query %s, attempt %d", queryId, attempt));
            try {
                GetQueryExecutionResult queryExecution = this.athenaInvoker.invoke(() -> this.athena.getQueryExecution(new GetQueryExecutionRequest().withQueryExecutionId(queryId)));
                String state = queryExecution.getQueryExecution().getStatus().getState();
                if (TERMINAL_STATES.contains(state)) {
                    logger.debug("Query {} has terminated with state {}", (Object)queryId, (Object)state);
                    this.isRunning.set(false);
                }
            }
            catch (Exception e) {
                logger.warn("Exception {} thrown when calling Athena for query status: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                if (!(e instanceof InvalidRequestException)) break block3;
                logger.debug("Athena reports query {} not found. Interrupting checker thread", (Object)queryId);
                throw new InterruptedException();
            }
        }
    }
}

