/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.ArrowTypeComparator;
import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;

public class EquatableValueSet
implements ValueSet {
    private static final String DEFAULT_COLUMN = "col1";
    private final boolean whiteList;
    private final Block valueBlock;
    public final boolean nullAllowed;

    @JsonCreator
    public EquatableValueSet(@JsonProperty(value="valueBlock") Block valueBlock, @JsonProperty(value="whiteList") boolean whiteList, @JsonProperty(value="nullAllowed") boolean nullAllowed) {
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        this.valueBlock = valueBlock;
        this.whiteList = whiteList;
        this.nullAllowed = nullAllowed;
    }

    public static Builder newBuilder(BlockAllocator allocator, ArrowType type, boolean isWhiteList, boolean nullAllowed) {
        return new Builder(allocator, type, isWhiteList, nullAllowed);
    }

    static EquatableValueSet none(BlockAllocator allocator, ArrowType type) {
        return new EquatableValueSet(BlockUtils.newEmptyBlock(allocator, DEFAULT_COLUMN, type), true, false);
    }

    static EquatableValueSet all(BlockAllocator allocator, ArrowType type) {
        return new EquatableValueSet(BlockUtils.newEmptyBlock(allocator, DEFAULT_COLUMN, type), false, true);
    }

    static EquatableValueSet onlyNull(BlockAllocator allocator, ArrowType type) {
        return new EquatableValueSet(BlockUtils.newEmptyBlock(allocator, DEFAULT_COLUMN, type), false, true);
    }

    static EquatableValueSet notNull(BlockAllocator allocator, ArrowType type) {
        return new EquatableValueSet(BlockUtils.newEmptyBlock(allocator, DEFAULT_COLUMN, type), false, false);
    }

    static EquatableValueSet of(BlockAllocator allocator, ArrowType type, Object ... values) {
        return new EquatableValueSet(BlockUtils.newBlock(allocator, DEFAULT_COLUMN, type, values), true, false);
    }

    static EquatableValueSet of(BlockAllocator allocator, ArrowType type, boolean nullAllowed, Collection<Object> values) {
        return new EquatableValueSet(BlockUtils.newBlock(allocator, DEFAULT_COLUMN, type, values), true, nullAllowed);
    }

    @Override
    @JsonProperty(value="nullAllowed")
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    @Transient
    protected Schema getSchema() {
        return this.valueBlock.getSchema();
    }

    @JsonProperty
    public Block getValueBlock() {
        return this.valueBlock;
    }

    @Override
    @Transient
    public ArrowType getType() {
        return this.valueBlock.getFieldReader(DEFAULT_COLUMN).getField().getType();
    }

    @JsonProperty
    public boolean isWhiteList() {
        return this.whiteList;
    }

    public Block getValues() {
        return this.valueBlock;
    }

    public Object getValue(int pos) {
        FieldReader reader = this.valueBlock.getFieldReader(DEFAULT_COLUMN);
        reader.setPosition(pos);
        return reader.readObject();
    }

    @Override
    public boolean isNone() {
        return this.whiteList && this.valueBlock.getRowCount() == 0 && !this.nullAllowed;
    }

    @Override
    public boolean isAll() {
        return !this.whiteList && this.valueBlock.getRowCount() == 0 && this.nullAllowed;
    }

    @Override
    public boolean isSingleValue() {
        return this.whiteList && this.valueBlock.getRowCount() == 1 && !this.nullAllowed || this.whiteList && this.valueBlock.getRowCount() == 0 && this.nullAllowed;
    }

    @Override
    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("EquatableValueSet does not have just a single value");
        }
        if (this.nullAllowed && this.valueBlock.getRowCount() == 0) {
            return null;
        }
        FieldReader reader = this.valueBlock.getFieldReader(DEFAULT_COLUMN);
        reader.setPosition(0);
        return reader.readObject();
    }

    @Override
    public boolean containsValue(Marker marker) {
        if (marker.isNullValue() && this.nullAllowed) {
            return true;
        }
        if (marker.isNullValue() && !this.nullAllowed) {
            return false;
        }
        Object value = marker.getValue();
        boolean result = false;
        FieldReader reader = this.valueBlock.getFieldReader(DEFAULT_COLUMN);
        for (int i = 0; i < this.valueBlock.getRowCount() && !result; ++i) {
            reader.setPosition(i);
            result = ArrowTypeComparator.compare(reader, value, reader.readObject()) == 0;
        }
        return this.whiteList == result;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null && this.nullAllowed) {
            return true;
        }
        boolean result = false;
        FieldReader reader = this.valueBlock.getFieldReader(DEFAULT_COLUMN);
        for (int i = 0; i < this.valueBlock.getRowCount() && !result; ++i) {
            reader.setPosition(i);
            result = ArrowTypeComparator.compare(reader, value, reader.readObject()) == 0;
        }
        return this.whiteList == result;
    }

    @Override
    public EquatableValueSet intersect(BlockAllocator allocator, ValueSet other) {
        boolean intersectNullAllowed;
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        boolean bl = intersectNullAllowed = this.isNullAllowed() && other.isNullAllowed();
        if (this.whiteList && otherValueSet.isWhiteList()) {
            return new EquatableValueSet(EquatableValueSet.intersect(allocator, this, otherValueSet), true, intersectNullAllowed);
        }
        if (this.whiteList) {
            return new EquatableValueSet(EquatableValueSet.subtract(allocator, this, otherValueSet), true, intersectNullAllowed);
        }
        if (otherValueSet.isWhiteList()) {
            return new EquatableValueSet(EquatableValueSet.subtract(allocator, otherValueSet, this), true, intersectNullAllowed);
        }
        return new EquatableValueSet(EquatableValueSet.union(allocator, otherValueSet, this), false, intersectNullAllowed);
    }

    @Override
    public EquatableValueSet union(BlockAllocator allocator, ValueSet other) {
        boolean unionNullAllowed;
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        boolean bl = unionNullAllowed = this.isNullAllowed() || other.isNullAllowed();
        if (this.whiteList && otherValueSet.isWhiteList()) {
            return new EquatableValueSet(EquatableValueSet.union(allocator, otherValueSet, this), true, unionNullAllowed);
        }
        if (this.whiteList) {
            return new EquatableValueSet(EquatableValueSet.subtract(allocator, otherValueSet, this), false, unionNullAllowed);
        }
        if (otherValueSet.isWhiteList()) {
            return new EquatableValueSet(EquatableValueSet.subtract(allocator, this, otherValueSet), false, unionNullAllowed);
        }
        return new EquatableValueSet(EquatableValueSet.intersect(allocator, otherValueSet, this), false, unionNullAllowed);
    }

    @Override
    public EquatableValueSet complement(BlockAllocator allocator) {
        return new EquatableValueSet(this.valueBlock, !this.whiteList, !this.nullAllowed);
    }

    public String toString() {
        return "EquatableValueSet{whiteList=" + this.whiteList + "nullAllowed=" + this.nullAllowed + ", valueBlock=" + this.valueBlock + "}";
    }

    private static Block intersect(BlockAllocator allocator, EquatableValueSet left, EquatableValueSet right) {
        Block resultBlock = BlockUtils.newEmptyBlock(allocator, DEFAULT_COLUMN, left.getType());
        FieldVector result = resultBlock.getFieldVector(DEFAULT_COLUMN);
        Block lhsBlock = left.getValues();
        FieldReader lhs = lhsBlock.getFieldReader(DEFAULT_COLUMN);
        int count = 0;
        for (int i = 0; i < lhsBlock.getRowCount(); ++i) {
            lhs.setPosition(i);
            if (!EquatableValueSet.isPresent(lhs.readObject(), right.valueBlock)) continue;
            BlockUtils.setValue(result, count++, lhs.readObject());
        }
        resultBlock.setRowCount(count);
        return resultBlock;
    }

    private static Block union(BlockAllocator allocator, EquatableValueSet left, EquatableValueSet right) {
        Block resultBlock = BlockUtils.newEmptyBlock(allocator, DEFAULT_COLUMN, left.getType());
        FieldVector result = resultBlock.getFieldVector(DEFAULT_COLUMN);
        Block lhsBlock = left.getValues();
        FieldReader lhs = lhsBlock.getFieldReader(DEFAULT_COLUMN);
        int count = 0;
        for (int i = 0; i < lhsBlock.getRowCount(); ++i) {
            lhs.setPosition(i);
            BlockUtils.setValue(result, count++, lhs.readObject());
        }
        Block rhsBlock = right.getValues();
        FieldReader rhs = rhsBlock.getFieldReader(DEFAULT_COLUMN);
        for (int i = 0; i < rhsBlock.getRowCount(); ++i) {
            rhs.setPosition(i);
            if (EquatableValueSet.isPresent(rhs.readObject(), left.valueBlock)) continue;
            BlockUtils.setValue(result, count++, rhs.readObject());
        }
        resultBlock.setRowCount(count);
        return resultBlock;
    }

    private static Block subtract(BlockAllocator allocator, EquatableValueSet left, EquatableValueSet right) {
        Block resultBlock = BlockUtils.newEmptyBlock(allocator, DEFAULT_COLUMN, left.getType());
        FieldVector result = resultBlock.getFieldVector(DEFAULT_COLUMN);
        Block lhsBlock = left.getValues();
        FieldReader lhs = lhsBlock.getFieldReader(DEFAULT_COLUMN);
        int count = 0;
        for (int i = 0; i < lhsBlock.getRowCount(); ++i) {
            lhs.setPosition(i);
            if (EquatableValueSet.isPresent(lhs.readObject(), right.valueBlock)) continue;
            BlockUtils.setValue(result, count++, lhs.readObject());
        }
        resultBlock.setRowCount(count);
        return resultBlock;
    }

    private static boolean isPresent(Object lhs, Block right) {
        FieldReader rhs = right.getFieldReader(DEFAULT_COLUMN);
        Types.MinorType type = rhs.getMinorType();
        for (int j = 0; j < right.getRowCount(); ++j) {
            rhs.setPosition(j);
            if (ArrowTypeComparator.compare(rhs, lhs, rhs.readObject()) != 0) continue;
            return true;
        }
        return false;
    }

    private EquatableValueSet checkCompatibility(ValueSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalStateException(String.format("Mismatched types: %s vs %s", this.getType(), other.getType()));
        }
        if (!(other instanceof EquatableValueSet)) {
            throw new IllegalStateException(String.format("ValueSet is not a EquatableValueSet: %s", other.getClass()));
        }
        return (EquatableValueSet)other;
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.whiteList, this.valueBlock, this.nullAllowed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EquatableValueSet other = (EquatableValueSet)obj;
        if ((this.getType() == null || other.getType() == null || Types.getMinorTypeForArrowType((ArrowType)this.getType()) != Types.getMinorTypeForArrowType((ArrowType)other.getType())) && this.getType() != other.getType()) {
            return false;
        }
        if (this.whiteList != other.whiteList) {
            return false;
        }
        if (this.nullAllowed != other.nullAllowed) {
            return false;
        }
        if (this.valueBlock == null && other.valueBlock != null) {
            return false;
        }
        return this.valueBlock == null || this.valueBlock.equalsAsSet(other.valueBlock);
    }

    @Override
    public void close() throws Exception {
        this.valueBlock.close();
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.getType().equals(marker.getType())) {
            throw new IllegalStateException(String.format("Marker of %s does not match SortedRangeSet of %s", marker.getType(), this.getType()));
        }
    }

    public static class Builder {
        private ArrowType type;
        private boolean isWhiteList;
        private boolean nullAllowed;
        private List<Object> values = new ArrayList<Object>();
        private BlockAllocator allocator;

        Builder(BlockAllocator allocator, ArrowType type, boolean isWhiteList, boolean nullAllowed) {
            Objects.requireNonNull(type, "minorType is null");
            this.allocator = allocator;
            this.type = type;
            this.isWhiteList = isWhiteList;
            this.nullAllowed = nullAllowed;
        }

        public Builder add(Object value) {
            this.values.add(value);
            return this;
        }

        public Builder addAll(Collection<Object> value) {
            this.values.addAll(value);
            return this;
        }

        public EquatableValueSet build() {
            return new EquatableValueSet(BlockUtils.newBlock(this.allocator, EquatableValueSet.DEFAULT_COLUMN, this.type, this.values), this.isWhiteList, this.nullAllowed);
        }
    }
}

