/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.domain.predicate.LiteralValueMarker;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.domain.predicate.Ranges;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueMarker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class SortedRangeSet
implements ValueSet {
    private final boolean nullAllowed;
    private final ArrowType type;
    private final NavigableMap<ValueMarker, Range> lowIndexedRanges;

    private SortedRangeSet(ArrowType type, NavigableMap<ValueMarker, Range> lowIndexedRanges, boolean nullAllowed) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(lowIndexedRanges, "lowIndexedRanges is null");
        this.type = type;
        this.lowIndexedRanges = lowIndexedRanges;
        this.nullAllowed = nullAllowed;
    }

    static SortedRangeSet none(ArrowType type) {
        return SortedRangeSet.copyOf(type, Collections.emptyList(), false);
    }

    static SortedRangeSet all(BlockAllocator allocator, ArrowType type) {
        return SortedRangeSet.copyOf(type, Collections.singletonList(Range.all(allocator, type)), true);
    }

    static SortedRangeSet onlyNull(ArrowType type) {
        return SortedRangeSet.copyOf(type, Collections.emptyList(), true);
    }

    static SortedRangeSet notNull(BlockAllocator allocator, ArrowType type) {
        return SortedRangeSet.copyOf(type, Collections.singletonList(Range.all(allocator, type)), false);
    }

    static SortedRangeSet of(BlockAllocator allocator, ArrowType type, Object first, Object ... rest) {
        return SortedRangeSet.of(allocator, type, false, first, Arrays.asList(rest));
    }

    static SortedRangeSet of(BlockAllocator allocator, ArrowType type, boolean nullAllowed, Object first, Collection<Object> rest) {
        ArrayList<Range> ranges = new ArrayList<Range>(rest.size() + 1);
        ranges.add(Range.equal(allocator, type, first));
        for (Object value : rest) {
            ranges.add(Range.equal(allocator, type, value));
        }
        return SortedRangeSet.copyOf(type, ranges, nullAllowed);
    }

    public static SortedRangeSet of(Range first, Range ... rest) {
        return SortedRangeSet.of(false, first, Arrays.asList(rest));
    }

    public static SortedRangeSet of(boolean nullAllowed, Range first, Range ... rest) {
        return SortedRangeSet.of(nullAllowed, first, Arrays.asList(rest));
    }

    public static SortedRangeSet of(boolean nullAllowed, Range first, Collection<Range> rest) {
        ArrayList<Range> rangeList = new ArrayList<Range>(rest.size() + 1);
        rangeList.add(first);
        for (Range range : rest) {
            rangeList.add(range);
        }
        return SortedRangeSet.copyOf(first.getType(), rangeList, nullAllowed);
    }

    static SortedRangeSet copyOf(ArrowType type, Iterable<Range> ranges, boolean nullAllowed) {
        return new Builder(type, nullAllowed).addAll(ranges).build();
    }

    @JsonCreator
    public static SortedRangeSet copyOf(@JsonProperty(value="type") ArrowType type, @JsonProperty(value="ranges") List<Range> ranges, @JsonProperty(value="nullAllowed") boolean nullAllowed) {
        return SortedRangeSet.copyOf(type, ranges, nullAllowed);
    }

    @Override
    @JsonProperty(value="nullAllowed")
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    @Override
    @JsonProperty
    public ArrowType getType() {
        return this.type;
    }

    @JsonProperty(value="ranges")
    public List<Range> getOrderedRanges() {
        return new ArrayList<Range>(this.lowIndexedRanges.values());
    }

    @Transient
    public int getRangeCount() {
        return this.lowIndexedRanges.size();
    }

    @Override
    @Transient
    public boolean isNone() {
        return this.lowIndexedRanges.isEmpty();
    }

    @Override
    @Transient
    public boolean isAll() {
        return this.lowIndexedRanges.size() == 1 && ((Range)this.lowIndexedRanges.values().iterator().next()).isAll();
    }

    @Override
    @Transient
    public boolean isSingleValue() {
        return this.lowIndexedRanges.size() == 1 && ((Range)this.lowIndexedRanges.values().iterator().next()).isSingleValue() && !this.nullAllowed || this.lowIndexedRanges.isEmpty() && this.nullAllowed;
    }

    @Override
    @Transient
    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("SortedRangeSet does not have just a single value");
        }
        if (this.nullAllowed && this.lowIndexedRanges.isEmpty()) {
            return null;
        }
        return ((Range)this.lowIndexedRanges.values().iterator().next()).getSingleValue();
    }

    @Override
    public boolean containsValue(Marker marker) {
        Objects.requireNonNull(marker, "marker is null");
        this.checkTypeCompatibility(marker);
        if (marker.isNullValue() && this.nullAllowed) {
            return true;
        }
        if (marker.isNullValue() && !this.nullAllowed) {
            return false;
        }
        if (marker.getBound() != Marker.Bound.EXACTLY) {
            throw new RuntimeException("Expected Bound.EXACTLY but found " + marker.getBound());
        }
        Map.Entry<ValueMarker, Range> floorEntry = this.lowIndexedRanges.floorEntry(marker);
        return floorEntry != null && floorEntry.getValue().includes(marker);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null && this.nullAllowed) {
            return true;
        }
        if (value == null && !this.nullAllowed) {
            return false;
        }
        LiteralValueMarker marker = new LiteralValueMarker(value, this.type);
        Map.Entry<ValueMarker, Range> floorEntry = this.lowIndexedRanges.floorEntry(marker);
        return floorEntry != null && floorEntry.getValue().includes(marker);
    }

    boolean includesMarker(Marker marker) {
        Objects.requireNonNull(marker, "marker is null");
        this.checkTypeCompatibility(marker);
        if (marker.isNullValue() && this.nullAllowed) {
            return true;
        }
        Map.Entry<ValueMarker, Range> floorEntry = this.lowIndexedRanges.floorEntry(marker);
        return floorEntry != null && floorEntry.getValue().includes(marker);
    }

    @Transient
    public Range getSpan() {
        if (this.lowIndexedRanges.isEmpty()) {
            throw new IllegalStateException("Can not get span if no ranges exist");
        }
        return this.lowIndexedRanges.firstEntry().getValue().span(this.lowIndexedRanges.lastEntry().getValue());
    }

    @Override
    public Ranges getRanges() {
        return new Ranges(){

            @Override
            public int getRangeCount() {
                return SortedRangeSet.this.getRangeCount();
            }

            @Override
            public List<Range> getOrderedRanges() {
                return SortedRangeSet.this.getOrderedRanges();
            }

            @Override
            public Range getSpan() {
                return SortedRangeSet.this.getSpan();
            }
        };
    }

    @Override
    public SortedRangeSet intersect(BlockAllocator allocator, ValueSet other) {
        SortedRangeSet otherRangeSet = this.checkCompatibility(other);
        boolean intersectNullAllowed = this.isNullAllowed() && other.isNullAllowed();
        Builder builder = new Builder(this.type, intersectNullAllowed);
        Iterator<Range> iterator1 = this.getOrderedRanges().iterator();
        Iterator<Range> iterator2 = otherRangeSet.getOrderedRanges().iterator();
        if (iterator1.hasNext() && iterator2.hasNext()) {
            Range range1 = iterator1.next();
            Range range2 = iterator2.next();
            while (true) {
                if (range1.overlaps(range2)) {
                    builder.add(range1.intersect(range2));
                }
                if (range1.getHigh().compareTo(range2.getHigh()) <= 0) {
                    if (!iterator1.hasNext()) break;
                    range1 = iterator1.next();
                    continue;
                }
                if (!iterator2.hasNext()) break;
                range2 = iterator2.next();
            }
        }
        return builder.build();
    }

    @Override
    public SortedRangeSet union(BlockAllocator allocator, ValueSet other) {
        boolean unionNullAllowed = this.isNullAllowed() || other.isNullAllowed();
        SortedRangeSet otherRangeSet = this.checkCompatibility(other);
        return new Builder(this.type, unionNullAllowed).addAll(this.getOrderedRanges()).addAll(otherRangeSet.getOrderedRanges()).build();
    }

    @Override
    public SortedRangeSet union(BlockAllocator allocator, Collection<ValueSet> valueSets) {
        boolean unionNullAllowed = this.isNullAllowed();
        for (ValueSet valueSet : valueSets) {
            unionNullAllowed |= valueSet.isNullAllowed();
        }
        Builder builder = new Builder(this.type, unionNullAllowed);
        builder.addAll(this.getOrderedRanges());
        for (ValueSet valueSet : valueSets) {
            builder.addAll(this.checkCompatibility(valueSet).getOrderedRanges());
        }
        return builder.build();
    }

    @Override
    public SortedRangeSet complement(BlockAllocator allocator) {
        Builder builder = new Builder(this.type, !this.nullAllowed);
        if (this.lowIndexedRanges.isEmpty()) {
            return builder.add(Range.all(allocator, this.type)).build();
        }
        Iterator rangeIterator = this.lowIndexedRanges.values().iterator();
        Range firstRange = (Range)rangeIterator.next();
        if (!firstRange.getLow().isLowerUnbounded()) {
            builder.add(new Range(Marker.lowerUnbounded(allocator, this.type), firstRange.getLow().lesserAdjacent()));
        }
        Range previousRange = firstRange;
        while (rangeIterator.hasNext()) {
            Range currentRange = (Range)rangeIterator.next();
            Marker lowMarker = previousRange.getHigh().greaterAdjacent();
            Marker highMarker = currentRange.getLow().lesserAdjacent();
            builder.add(new Range(lowMarker, highMarker));
            previousRange = currentRange;
        }
        Range lastRange = previousRange;
        if (!lastRange.getHigh().isUpperUnbounded()) {
            builder.add(new Range(lastRange.getHigh().greaterAdjacent(), Marker.upperUnbounded(allocator, this.type)));
        }
        return builder.build();
    }

    private SortedRangeSet checkCompatibility(ValueSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalStateException(String.format("Mismatched types: %s vs %s", this.getType(), other.getType()));
        }
        if (!(other instanceof SortedRangeSet)) {
            throw new IllegalStateException(String.format("ValueSet is not a SortedRangeSet: %s", other.getClass()));
        }
        return (SortedRangeSet)other;
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.getType().equals(marker.getType()) && !this.checkTypeCompatibilityForTimeStamp(marker)) {
            throw new IllegalStateException(String.format("Marker of %s does not match SortedRangeSet of %s", marker.getType(), this.getType()));
        }
    }

    private boolean checkTypeCompatibilityForTimeStamp(Marker marker) {
        return this.getType() instanceof ArrowType.Timestamp && ((ArrowType.Timestamp)this.getType()).getUnit().equals((Object)((ArrowType.Timestamp)marker.getType()).getUnit());
    }

    public int hashCode() {
        return Objects.hash(this.lowIndexedRanges, this.nullAllowed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SortedRangeSet other = (SortedRangeSet)obj;
        if (this.nullAllowed != other.isNullAllowed()) {
            return false;
        }
        return Objects.equals(this.lowIndexedRanges, other.lowIndexedRanges);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("nullAllowed", this.nullAllowed).add("lowIndexedRanges", this.lowIndexedRanges).toString();
    }

    public static Builder newBuilder(ArrowType type, boolean nullAllowed) {
        return new Builder(type, nullAllowed);
    }

    @Override
    public void close() throws Exception {
        for (Map.Entry next : this.lowIndexedRanges.entrySet()) {
            if (next.getKey() instanceof Marker) {
                ((Marker)next.getKey()).close();
            }
            ((Range)next.getValue()).close();
        }
    }

    public static class Builder {
        private final ArrowType type;
        private final boolean nullAllowed;
        private final List<Range> ranges = new ArrayList<Range>();

        Builder(ArrowType type, boolean nullAllowed) {
            Objects.requireNonNull(type, "type is null");
            this.type = type;
            this.nullAllowed = nullAllowed;
        }

        public Builder add(Range range) {
            if (!this.type.equals(range.getType())) {
                throw new IllegalArgumentException(String.format("Range type %s does not match builder type %s", range.getType(), this.type));
            }
            this.ranges.add(range);
            return this;
        }

        public Builder addAll(Iterable<Range> arg) {
            for (Range range : arg) {
                this.add(range);
            }
            return this;
        }

        public SortedRangeSet build() {
            Collections.sort(this.ranges, Comparator.comparing(Range::getLow));
            TreeMap<ValueMarker, Range> result = new TreeMap<ValueMarker, Range>();
            Range current = null;
            for (Range next : this.ranges) {
                if (current == null) {
                    current = next;
                    continue;
                }
                if (current.overlaps(next) || current.getHigh().isAdjacent(next.getLow())) {
                    current = current.span(next);
                    continue;
                }
                result.put(current.getLow(), current);
                current = next;
            }
            if (current != null) {
                result.put(current.getLow(), current);
            }
            return new SortedRangeSet(this.type, result, this.nullAllowed);
        }
    }
}

