/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.examples;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.data.BlockSpiller;
import com.amazonaws.athena.connector.lambda.data.writers.GeneratedRowWriter;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.Extractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriterFactory;
import com.amazonaws.athena.connector.lambda.exceptions.FederationThrottleException;
import com.amazonaws.athena.connector.lambda.handlers.RecordHandler;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.PingRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.athena.AmazonAthenaClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.google.common.base.Charsets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleRecordHandler
extends RecordHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExampleRecordHandler.class);
    private static final String SOURCE_TYPE = "custom";
    private static final String NUM_ROWS_PER_SPLIT = "NUM_ROWS_PER_SPLIT";
    private static final String SIMULATE_THROTTLES = "SIMULATE_THROTTLES";
    private int numRowsPerSplit = 400000;
    private final int simulateThrottle;
    private int count = 0;

    public ExampleRecordHandler(Map<String, String> configOptions) {
        this(AmazonS3ClientBuilder.defaultClient(), AWSSecretsManagerClientBuilder.defaultClient(), AmazonAthenaClientBuilder.defaultClient(), configOptions);
        if (configOptions.get(NUM_ROWS_PER_SPLIT) != null) {
            this.numRowsPerSplit = Integer.parseInt(configOptions.get(NUM_ROWS_PER_SPLIT));
        }
    }

    @VisibleForTesting
    protected ExampleRecordHandler(AmazonS3 amazonS3, AWSSecretsManager secretsManager, AmazonAthena athena, Map<String, String> configOptions) {
        super(amazonS3, secretsManager, athena, SOURCE_TYPE, configOptions);
        this.simulateThrottle = configOptions.get(SIMULATE_THROTTLES) == null ? 0 : Integer.parseInt(configOptions.get(SIMULATE_THROTTLES));
    }

    @VisibleForTesting
    protected void setNumRows(int numRows) {
        this.numRowsPerSplit = numRows;
    }

    private void logCaller(FederationRequest request) {
        FederatedIdentity identity = request.getIdentity();
        logger.info("logCaller: account[" + identity.getAccount() + "] arn[" + identity.getArn() + "]");
    }

    @Override
    protected void onPing(PingRequest request) {
        this.logCaller(request);
    }

    @Override
    protected void readWithConstraint(BlockSpiller spiller, ReadRecordsRequest request, QueryStatusChecker queryStatusChecker) {
        long startTime = System.currentTimeMillis();
        if (this.simulateThrottle > 0 && this.count++ % this.simulateThrottle == 0) {
            logger.info("readWithConstraint: throwing throttle Exception!");
            throw new FederationThrottleException("Please slow down for this simulated throttling event");
        }
        this.logCaller(request);
        HashSet<String> partitionCols = new HashSet<String>();
        String partitionColsMetadata = (String)request.getSchema().getCustomMetadata().get("partitionCols");
        if (partitionColsMetadata != null) {
            partitionCols.addAll(Arrays.asList(partitionColsMetadata.split(",")));
        }
        int year = Integer.valueOf(request.getSplit().getProperty("year"));
        int month = Integer.valueOf(request.getSplit().getProperty("month"));
        int day = Integer.valueOf(request.getSplit().getProperty("day"));
        RowContext rowContext = new RowContext(year, month, day);
        GeneratedRowWriter.RowWriterBuilder builder = GeneratedRowWriter.newBuilder(request.getConstraints());
        for (Field next : request.getSchema().getFields()) {
            Extractor extractor = this.makeExtractor(next, rowContext);
            if (extractor != null) {
                builder.withExtractor(next.getName(), extractor);
                continue;
            }
            builder.withFieldWriterFactory(next.getName(), this.makeFactory(next, rowContext));
        }
        GeneratedRowWriter rowWriter = builder.build();
        for (int i = 0; i < this.numRowsPerSplit; ++i) {
            rowContext.seed = i;
            boolean bl = rowContext.negative = i % 2 == 0;
            if (!queryStatusChecker.isQueryRunning()) {
                return;
            }
            spiller.writeRows((block, rowNum) -> rowWriter.writeRow(block, rowNum, rowContext) ? 1 : 0);
        }
        logger.info("readWithConstraint: Completed generating rows in {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private Extractor makeExtractor(Field field, RowContext rowContext) {
        Types.MinorType fieldType = Types.getMinorTypeForArrowType((ArrowType)field.getType());
        if (field.getName().equals("year")) {
            return (context, dst) -> {
                dst.isSet = 1;
                dst.value = rowContext.getYear();
            };
        }
        if (field.getName().equals("month")) {
            return (context, dst) -> {
                dst.isSet = 1;
                dst.value = rowContext.getMonth();
            };
        }
        if (field.getName().equals("day")) {
            return (context, dst) -> {
                dst.isSet = 1;
                dst.value = rowContext.getDay();
            };
        }
        switch (fieldType) {
            case INT: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = ((RowContext)context).seed * (((RowContext)context).negative ? -1 : 1);
                };
            }
            case DATEMILLI: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = ((RowContext)context).seed * (((RowContext)context).negative ? -1 : 1);
                };
            }
            case DATEDAY: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = ((RowContext)context).seed * (((RowContext)context).negative ? -1 : 1);
                };
            }
            case TINYINT: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = (byte)(((RowContext)context).seed % 4 * (((RowContext)context).negative ? -1 : 1));
                };
            }
            case SMALLINT: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = (short)(((RowContext)context).seed % 4 * (((RowContext)context).negative ? -1 : 1));
                };
            }
            case FLOAT4: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = (float)((RowContext)context).seed * 1.1f * (((RowContext)context).negative ? -1.0f : 1.0f);
                };
            }
            case FLOAT8: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = (double)((RowContext)context).seed * 1.1;
                };
            }
            case DECIMAL: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    double d8Val = (double)((RowContext)context).seed * 1.1 * (((RowContext)context).negative ? -1.0 : 1.0);
                    BigDecimal bdVal = new BigDecimal(d8Val);
                    dst.value = bdVal.setScale(((ArrowType.Decimal)field.getType()).getScale(), RoundingMode.HALF_UP);
                };
            }
            case BIT: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = ((RowContext)context).seed % 2;
                };
            }
            case BIGINT: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = (long)((RowContext)context).seed * 1L * (long)(((RowContext)context).negative ? -1 : 1);
                };
            }
            case VARCHAR: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = "VarChar" + ((RowContext)context).seed;
                };
            }
            case VARBINARY: {
                return (context, dst) -> {
                    dst.isSet = 1;
                    dst.value = ("VarChar" + ((RowContext)context).seed).getBytes(Charsets.UTF_8);
                };
            }
        }
        return null;
    }

    private FieldWriterFactory makeFactory(Field field, RowContext rowContext) {
        Types.MinorType fieldType = Types.getMinorTypeForArrowType((ArrowType)field.getType());
        switch (fieldType) {
            case LIST: {
                Field child = (Field)field.getChildren().get(0);
                Types.MinorType childType = Types.getMinorTypeForArrowType((ArrowType)child.getType());
                switch (childType) {
                    case LIST: {
                        return (vector, extractor, constraint) -> (context, rowNum) -> {
                            UnionListWriter writer = ((ListVector)vector).getWriter();
                            writer.setPosition(rowNum);
                            writer.startList();
                            BaseWriter.ListWriter innerWriter = writer.list();
                            innerWriter.startList();
                            for (int i = 0; i < 3; ++i) {
                                byte[] bytes = String.valueOf(1000 + i).getBytes(Charsets.UTF_8);
                                try (ArrowBuf buf = vector.getAllocator().buffer((long)bytes.length);){
                                    buf.writeBytes(bytes);
                                    innerWriter.varChar().writeVarChar(0, (int)buf.readableBytes(), buf);
                                    continue;
                                }
                            }
                            innerWriter.endList();
                            writer.endList();
                            ((ListVector)vector).setNotNull(rowNum);
                            return true;
                        };
                    }
                    case STRUCT: {
                        return (vector, extractor, constraint) -> (context, rowNum) -> {
                            UnionListWriter writer = ((ListVector)vector).getWriter();
                            writer.setPosition(rowNum);
                            writer.startList();
                            BaseWriter.StructWriter structWriter = writer.struct();
                            structWriter.start();
                            byte[] bytes = "chars".getBytes(Charsets.UTF_8);
                            try (ArrowBuf buf = vector.getAllocator().buffer((long)bytes.length);){
                                buf.writeBytes(bytes);
                                structWriter.varChar("varchar").writeVarChar(0, (int)buf.readableBytes(), buf);
                            }
                            structWriter.bigInt("bigint").writeBigInt(100L);
                            structWriter.end();
                            writer.endList();
                            ((ListVector)vector).setNotNull(rowNum);
                            return true;
                        };
                    }
                }
                throw new IllegalArgumentException("Unsupported type " + childType);
            }
            case MAP: {
                return (vector, extractor, constraint) -> (context, rowNum) -> {
                    UnionMapWriter writer = ((MapVector)vector).getWriter();
                    writer.setPosition(rowNum);
                    writer.startMap();
                    writer.startEntry();
                    byte[] bytes = "chars".getBytes(Charsets.UTF_8);
                    try (ArrowBuf buf = vector.getAllocator().buffer((long)bytes.length);){
                        buf.writeBytes(bytes);
                        writer.key().varChar("key").writeVarChar(0, (int)buf.readableBytes(), buf);
                    }
                    writer.value().integer("value").writeInt(1001);
                    writer.endEntry();
                    writer.endMap();
                    ((MapVector)vector).setNotNull(rowNum);
                    return true;
                };
            }
        }
        throw new IllegalArgumentException("Unsupported type " + fieldType);
    }

    private static class RowContext {
        private int seed;
        private boolean negative;
        private final int year;
        private final int month;
        private final int day;

        public RowContext(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getSeed() {
            return this.seed;
        }

        public void setSeed(int seed) {
            this.seed = seed;
        }

        public boolean isNegative() {
            return this.negative;
        }

        public void setNegative(boolean negative) {
            this.negative = negative;
        }
    }
}

