/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.arrow.vector.types.pojo.Schema;

public class GetTableLayoutRequest
extends MetadataRequest {
    private final TableName tableName;
    private final Constraints constraints;
    private final Schema schema;
    private final Set<String> partitionCols;

    @JsonCreator
    public GetTableLayoutRequest(@JsonProperty(value="identity") FederatedIdentity identity, @JsonProperty(value="queryId") String queryId, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="tableName") TableName tableName, @JsonProperty(value="constraints") Constraints constraints, @JsonProperty(value="schema") Schema schema, @JsonProperty(value="partitionCols") Set<String> partitionCols) {
        super(identity, MetadataRequestType.GET_TABLE_LAYOUT, queryId, catalogName);
        Objects.requireNonNull(partitionCols, "partitionCols is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.constraints = Objects.requireNonNull(constraints, "constraints is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.partitionCols = Collections.unmodifiableSet(new HashSet<String>(partitionCols));
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Set<String> getPartitionCols() {
        return this.partitionCols;
    }

    @Override
    public void close() throws Exception {
        for (ValueSet next : this.constraints.getSummary().values()) {
            next.close();
        }
        this.constraints.close();
    }

    public String toString() {
        return "GetTableLayoutRequest{queryId=" + this.getQueryId() + ", tableName=" + this.tableName + ", constraints=" + this.constraints + ", schema=" + this.schema + ", partitionCols=" + this.partitionCols + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTableLayoutRequest that = (GetTableLayoutRequest)o;
        return com.google.common.base.Objects.equal((Object)this.tableName, (Object)that.tableName) && com.google.common.base.Objects.equal((Object)this.constraints, (Object)that.constraints) && com.google.common.base.Objects.equal((Object)this.schema, (Object)that.schema) && com.google.common.base.Objects.equal(this.partitionCols, that.partitionCols) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tableName, this.constraints, this.schema, this.partitionCols, this.getRequestType(), this.getCatalogName()});
    }
}

