/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.metadata.MetadataResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.arrow.vector.types.pojo.Schema;

public class GetTableResponse
extends MetadataResponse {
    private final TableName tableName;
    private final Schema schema;
    private final Set<String> partitionColumns;

    @JsonCreator
    public GetTableResponse(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="tableName") TableName tableName, @JsonProperty(value="schema") Schema schema, @JsonProperty(value="partitionColumns") Set<String> partitionColumns) {
        super(MetadataRequestType.GET_TABLE, catalogName);
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        this.tableName = tableName;
        this.schema = schema;
        this.partitionColumns = partitionColumns;
    }

    public GetTableResponse(String catalogName, TableName tableName, Schema schema) {
        this(catalogName, tableName, schema, Collections.emptySet());
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Set<String> getPartitionColumns() {
        return Collections.unmodifiableSet(this.partitionColumns);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("schema", (Object)this.schema).add("partitionColumns", this.partitionColumns).add("requestType", (Object)this.getRequestType()).add("catalogName", (Object)this.getCatalogName()).toString();
    }

    @Override
    public void close() throws Exception {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTableResponse that = (GetTableResponse)o;
        return com.google.common.base.Objects.equal((Object)this.tableName, (Object)that.tableName) && com.google.common.base.Objects.equal((Object)this.schema, (Object)that.schema) && com.google.common.base.Objects.equal(this.partitionColumns, that.partitionColumns) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tableName, this.schema, this.partitionColumns, this.getRequestType(), this.getRequestType()});
    }
}

