/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata.glue;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueTypeParser {
    private static final Logger logger = LoggerFactory.getLogger(GlueTypeParser.class);
    protected static final Character FIELD_START = Character.valueOf('<');
    protected static final Character FIELD_END = Character.valueOf('>');
    protected static final Character FIELD_DIV = Character.valueOf(':');
    protected static final Character FIELD_SEP = Character.valueOf(',');
    protected static final Character ESCAPE_CHAR = Character.valueOf('\\');
    protected static final Character FIELD_PARAM_START = Character.valueOf('(');
    protected static final Character FIELD_PARAM_END = Character.valueOf(')');
    private static final Set<Character> TOKENS = new HashSet<Character>();
    private final String input;
    private int pos;
    private Token current = null;

    public GlueTypeParser(String input) {
        this.input = input;
        this.pos = 0;
    }

    public boolean hasNext() {
        return this.pos < this.input.length();
    }

    public Token next() {
        StringBuilder sb = new StringBuilder();
        int readPos = this.pos;
        int lastEscapeChar = -1;
        boolean fieldParamsContext = false;
        while (this.input.length() > readPos) {
            Character last;
            if ((last = Character.valueOf(this.input.charAt(readPos++))).equals(ESCAPE_CHAR)) {
                lastEscapeChar = readPos - 1;
                continue;
            }
            if (last.equals(Character.valueOf(' '))) continue;
            if (fieldParamsContext) {
                if (last == FIELD_PARAM_END) {
                    fieldParamsContext = false;
                }
                sb.append(last);
                continue;
            }
            if (!TOKENS.contains(last) || lastEscapeChar == readPos - 2) {
                if (last == FIELD_PARAM_START) {
                    fieldParamsContext = true;
                }
                sb.append(last);
                continue;
            }
            this.pos = readPos;
            this.current = new Token(sb.toString(), last, readPos);
            logger.debug("next: {}", (Object)this.current);
            return this.current;
        }
        this.pos = readPos;
        this.current = new Token(sb.toString(), null, readPos);
        logger.debug("next: {}", (Object)this.current);
        return this.current;
    }

    public Token currentToken() {
        return this.current;
    }

    static {
        TOKENS.add(FIELD_START);
        TOKENS.add(FIELD_END);
        TOKENS.add(FIELD_DIV);
        TOKENS.add(FIELD_SEP);
    }

    public static class Token {
        private final String value;
        private final Character marker;
        private final int pos;

        public Token(String value, Character marker, int pos) {
            this.value = value;
            this.marker = marker;
            this.pos = pos;
        }

        public String getValue() {
            return this.value;
        }

        public Character getMarker() {
            return this.marker;
        }

        public int getPos() {
            return this.pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Token token = (Token)o;
            if (this.getMarker() == null && token.getMarker() != null) {
                return false;
            }
            return this.getPos() == token.getPos() && this.getValue().equals(token.getValue()) && (this.getMarker() == null || this.getMarker().equals(token.getMarker()));
        }

        public int hashCode() {
            return Objects.hash(this.getValue(), this.getMarker(), this.getPos());
        }

        public String toString() {
            return "Token{value='" + this.value + "', marker=" + this.marker + ", pos=" + this.pos + "}";
        }
    }
}

