/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.SplitSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

public final class GetSplitsResponseSerDe {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String SPLITS_FIELD = "splits";
    private static final String CONTINUATION_TOKEN_FIELD = "continuationToken";

    private GetSplitsResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        private final SplitSerDe.Deserializer splitDeserializer;

        public Deserializer(SplitSerDe.Deserializer splitDeserializer) {
            super(FederationResponse.class, GetSplitsResponse.class);
            this.splitDeserializer = Objects.requireNonNull(splitDeserializer, "splitDeserializer is null");
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String catalogName = this.getNextStringField(jparser, GetSplitsResponseSerDe.CATALOG_NAME_FIELD);
            this.assertFieldName(jparser, GetSplitsResponseSerDe.SPLITS_FIELD);
            this.validateArrayStart(jparser);
            ImmutableSet.Builder splitsSet = ImmutableSet.builder();
            while (jparser.nextToken() != JsonToken.END_ARRAY) {
                this.validateObjectStart(jparser.getCurrentToken());
                splitsSet.add((Object)this.splitDeserializer.doDeserialize(jparser, ctxt));
                this.validateObjectEnd(jparser);
            }
            String continuationToken = this.getNextStringField(jparser, GetSplitsResponseSerDe.CONTINUATION_TOKEN_FIELD);
            return new GetSplitsResponse(catalogName, (Set<Split>)splitsSet.build(), continuationToken);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        private final SplitSerDe.Serializer splitSerializer;

        public Serializer(SplitSerDe.Serializer splitSerializer) {
            super(FederationResponse.class, GetSplitsResponse.class);
            this.splitSerializer = Objects.requireNonNull(splitSerializer, "splitSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            GetSplitsResponse getSplitsResponse = (GetSplitsResponse)federationResponse;
            jgen.writeStringField(GetSplitsResponseSerDe.CATALOG_NAME_FIELD, getSplitsResponse.getCatalogName());
            jgen.writeArrayFieldStart(GetSplitsResponseSerDe.SPLITS_FIELD);
            for (Split split : getSplitsResponse.getSplits()) {
                this.splitSerializer.serialize(split, jgen, provider);
            }
            jgen.writeEndArray();
            jgen.writeStringField(GetSplitsResponseSerDe.CONTINUATION_TOKEN_FIELD, getSplitsResponse.getContinuationToken());
        }
    }
}

