/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.metadata.ListSchemasResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;

public final class ListSchemasResponseSerDe {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String SCHEMAS_FIELD = "schemas";

    private ListSchemasResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        public Deserializer() {
            super(FederationResponse.class, ListSchemasResponse.class);
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String catalogName = this.getNextStringField(jparser, ListSchemasResponseSerDe.CATALOG_NAME_FIELD);
            List<String> schemas = this.getNextStringArray(jparser, ListSchemasResponseSerDe.SCHEMAS_FIELD);
            return new ListSchemasResponse(catalogName, schemas);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        public Serializer() {
            super(FederationResponse.class, ListSchemasResponse.class);
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            ListSchemasResponse listSchemasResponse = (ListSchemasResponse)federationResponse;
            jgen.writeStringField(ListSchemasResponseSerDe.CATALOG_NAME_FIELD, listSchemasResponse.getCatalogName());
            this.writeStringArray(jgen, ListSchemasResponseSerDe.SCHEMAS_FIELD, listSchemasResponse.getSchemas());
        }
    }
}

