/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.udf;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;

public class UserDefinedFunctionRequest
extends FederationRequest {
    private final Block inputRecords;
    private final Schema outputSchema;
    private final String methodName;
    private final UserDefinedFunctionType functionType;

    @JsonCreator
    public UserDefinedFunctionRequest(@JsonProperty(value="identity") FederatedIdentity identity, @JsonProperty(value="inputRecords") Block inputRecords, @JsonProperty(value="outputSchema") Schema outputSchema, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="functionType") UserDefinedFunctionType functionType) {
        super(identity);
        this.inputRecords = Objects.requireNonNull(inputRecords, "inputRecords is null");
        this.outputSchema = Objects.requireNonNull(outputSchema, "outputSchema is null");
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        this.functionType = Objects.requireNonNull(functionType, "functionType is null");
    }

    @Override
    public void close() throws Exception {
        this.inputRecords.close();
    }

    @JsonProperty(value="inputRecords")
    public Block getInputRecords() {
        return this.inputRecords;
    }

    @JsonProperty(value="outputSchema")
    public Schema getOutputSchema() {
        return this.outputSchema;
    }

    @JsonProperty(value="methodName")
    public String getMethodName() {
        return this.methodName;
    }

    @JsonProperty(value="functionType")
    public UserDefinedFunctionType getFunctionType() {
        return this.functionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserDefinedFunctionRequest)) {
            return false;
        }
        UserDefinedFunctionRequest that = (UserDefinedFunctionRequest)o;
        return this.getInputRecords().equals(that.getInputRecords()) && this.getOutputSchema().equals((Object)that.getOutputSchema()) && this.getMethodName().equals(that.getMethodName()) && this.getFunctionType() == that.getFunctionType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getInputRecords(), this.getOutputSchema(), this.getMethodName(), this.getFunctionType()});
    }
}

