/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public interface FieldResolver {
    public static final FieldResolver DEFAULT = new FieldResolver(){

        @Override
        public Object getFieldValue(Field field, Object value) {
            Types.MinorType minorType = Types.getMinorTypeForArrowType((ArrowType)field.getType());
            if (value instanceof Map) {
                return ((Map)value).get(field.getName());
            }
            if (minorType == Types.MinorType.LIST) {
                return ((List)value).iterator();
            }
            throw new RuntimeException("Expected LIST type but found " + minorType);
        }
    };

    public Object getFieldValue(Field var1, Object var2);

    default public Object getMapKey(Field field, Object value) {
        return value;
    }

    default public Object getMapValue(Field field, Object value) {
        return value;
    }
}

