/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.projectors;

import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.projectors.ArrowValueProjector;
import com.amazonaws.athena.connector.lambda.data.projectors.ListArrowValueProjector;
import com.amazonaws.athena.connector.lambda.data.projectors.StructArrowValueProjector;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Objects;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.util.Text;

public abstract class ArrowValueProjectorImpl
implements ArrowValueProjector {
    protected Projection createValueProjection(Types.MinorType minorType) {
        switch (minorType) {
            case LIST: 
            case STRUCT: {
                return this.createComplexValueProjection(minorType);
            }
        }
        return this.createSimpleValueProjection(minorType);
    }

    private Projection createSimpleValueProjection(Types.MinorType minorType) {
        switch (minorType) {
            case DATEMILLI: {
                return fieldReader -> {
                    if (Objects.isNull(fieldReader.readLocalDateTime())) {
                        return null;
                    }
                    long millis = fieldReader.readLocalDateTime().atZone(BlockUtils.UTC_ZONE_ID).toInstant().toEpochMilli();
                    return Instant.ofEpochMilli(millis).atZone(BlockUtils.UTC_ZONE_ID).toLocalDateTime();
                };
            }
            case TINYINT: 
            case UINT1: {
                return fieldReader -> fieldReader.readByte();
            }
            case UINT2: {
                return fieldReader -> fieldReader.readCharacter();
            }
            case SMALLINT: {
                return fieldReader -> fieldReader.readShort();
            }
            case DATEDAY: {
                return fieldReader -> {
                    Integer intVal = fieldReader.readInteger();
                    if (Objects.isNull(intVal)) {
                        return null;
                    }
                    return LocalDate.ofEpochDay(intVal.intValue());
                };
            }
            case INT: 
            case UINT4: {
                return fieldReader -> fieldReader.readInteger();
            }
            case UINT8: 
            case BIGINT: {
                return fieldReader -> fieldReader.readLong();
            }
            case DECIMAL: {
                return fieldReader -> fieldReader.readBigDecimal();
            }
            case FLOAT4: {
                return fieldReader -> fieldReader.readFloat();
            }
            case FLOAT8: {
                return fieldReader -> fieldReader.readDouble();
            }
            case VARCHAR: {
                return fieldReader -> {
                    Text text = fieldReader.readText();
                    if (Objects.isNull(text)) {
                        return null;
                    }
                    return text.toString();
                };
            }
            case VARBINARY: {
                return fieldReader -> fieldReader.readByteArray();
            }
            case BIT: {
                return fieldReader -> fieldReader.readBoolean();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + minorType);
    }

    private Projection createComplexValueProjection(Types.MinorType minorType) {
        switch (minorType) {
            case LIST: {
                return fieldReader -> {
                    ListArrowValueProjector subListProjector = new ListArrowValueProjector(fieldReader);
                    return subListProjector.doProject();
                };
            }
            case STRUCT: {
                return fieldReader -> {
                    StructArrowValueProjector subStructProjector = new StructArrowValueProjector(fieldReader);
                    return subStructProjector.doProject();
                };
            }
        }
        throw new IllegalArgumentException("Unsupported type " + minorType);
    }

    static interface Projection {
        public Object doProjection(FieldReader var1);
    }
}

