/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.BigIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;

public class BigIntFieldWriter
implements FieldWriter {
    private final NullableBigIntHolder holder = new NullableBigIntHolder();
    private final BigIntExtractor extractor;
    private final BigIntVector vector;
    private final ConstraintApplier constraint;

    public BigIntFieldWriter(BigIntExtractor extractor, BigIntVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : Long.valueOf(value.value)) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        this.vector.setSafe(rowNum, this.holder);
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableBigIntHolder var1);
    }
}

