/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.DateDayExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.holders.NullableDateDayHolder;

public class DateDayFieldWriter
implements FieldWriter {
    private final NullableDateDayHolder holder = new NullableDateDayHolder();
    private final DateDayExtractor extractor;
    private final DateDayVector vector;
    private final ConstraintApplier constraint;

    public DateDayFieldWriter(DateDayExtractor extractor, DateDayVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : Integer.valueOf(value.value)) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        this.vector.setSafe(rowNum, this.holder);
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableDateDayHolder var1);
    }
}

