/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class TableName {
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public TableName(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableName that = (TableName)o;
        return com.google.common.base.Objects.equal((Object)this.schemaName, (Object)that.schemaName) && com.google.common.base.Objects.equal((Object)this.tableName, (Object)that.tableName);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.schemaName, this.tableName});
    }

    public String getQualifiedTableName() {
        return String.format("%s.%s", this.schemaName, this.tableName);
    }
}

