/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class AllOrNoneValueSet
implements ValueSet {
    private final ArrowType type;
    private final boolean all;
    private final boolean nullAllowed;

    @JsonCreator
    public AllOrNoneValueSet(@JsonProperty(value="type") ArrowType type, @JsonProperty(value="all") boolean all, @JsonProperty(value="nullAllowed") boolean nullAllowed) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.all = all;
        this.nullAllowed = nullAllowed;
    }

    static AllOrNoneValueSet all(ArrowType type) {
        return new AllOrNoneValueSet(type, true, true);
    }

    static AllOrNoneValueSet none(ArrowType type) {
        return new AllOrNoneValueSet(type, false, false);
    }

    static AllOrNoneValueSet onlyNull(ArrowType type) {
        return new AllOrNoneValueSet(type, false, true);
    }

    static AllOrNoneValueSet notNull(ArrowType type) {
        return new AllOrNoneValueSet(type, true, false);
    }

    @Override
    @JsonProperty(value="nullAllowed")
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    @Override
    @JsonProperty
    public ArrowType getType() {
        return this.type;
    }

    @Override
    public boolean isNone() {
        return !this.all && !this.nullAllowed;
    }

    @Override
    @JsonProperty
    public boolean isAll() {
        return this.all && this.nullAllowed;
    }

    @Override
    public boolean isSingleValue() {
        return false;
    }

    @Override
    public Object getSingleValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Marker value) {
        if (value.isNullValue() && this.nullAllowed) {
            return true;
        }
        if (value.isNullValue() && !this.nullAllowed) {
            return false;
        }
        return this.all;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null && this.nullAllowed) {
            return true;
        }
        if (value == null && !this.nullAllowed) {
            return false;
        }
        return this.all;
    }

    @Override
    public ValueSet intersect(BlockAllocator allocator, ValueSet other) {
        AllOrNoneValueSet otherValueSet = this.checkCompatibility(other);
        return new AllOrNoneValueSet(this.type, this.all && otherValueSet.all, this.nullAllowed && other.isNullAllowed());
    }

    @Override
    public ValueSet union(BlockAllocator allocator, ValueSet other) {
        AllOrNoneValueSet otherValueSet = this.checkCompatibility(other);
        return new AllOrNoneValueSet(this.type, this.all || otherValueSet.all, this.nullAllowed || other.isNullAllowed());
    }

    @Override
    public ValueSet complement(BlockAllocator allocator) {
        return new AllOrNoneValueSet(this.type, !this.all, !this.nullAllowed);
    }

    public String toString() {
        return "[" + (this.all ? "ALL" : "NONE") + " nullAllowed:" + this.isNullAllowed() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.type, this.all);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllOrNoneValueSet other = (AllOrNoneValueSet)obj;
        return Objects.equals(this.type, other.type) && this.all == other.all;
    }

    private AllOrNoneValueSet checkCompatibility(ValueSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched types: %s vs %s", this.getType(), other.getType()));
        }
        if (!(other instanceof AllOrNoneValueSet)) {
            throw new IllegalArgumentException(String.format("ValueSet is not a AllOrNoneValueSet: %s", other.getClass()));
        }
        return (AllOrNoneValueSet)other;
    }

    @Override
    public void close() throws Exception {
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.getType().equals(marker.getType())) {
            throw new IllegalStateException(String.format("Marker of %s does not match SortedRangeSet of %s", marker.getType(), this.getType()));
        }
    }
}

