/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.domain.predicate.OrderByField;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FederationExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Constraints
implements AutoCloseable {
    public static final long DEFAULT_NO_LIMIT = -1L;
    private Map<String, ValueSet> summary;
    private List<FederationExpression> expression;
    private final List<OrderByField> orderByClause;
    private long limit;

    @Deprecated
    public Constraints(Map<String, ValueSet> summary) {
        this(summary, Collections.emptyList(), Collections.emptyList(), -1L);
    }

    @JsonCreator
    public Constraints(@JsonProperty(value="summary") Map<String, ValueSet> summary, @JsonProperty(value="expression") List<FederationExpression> expression, @JsonProperty(value="orderByClause") List<OrderByField> orderByClause, @JsonProperty(value="limit") long limit) {
        this.summary = summary;
        this.expression = expression;
        this.orderByClause = orderByClause;
        this.limit = limit;
    }

    public Map<String, ValueSet> getSummary() {
        return this.summary;
    }

    public List<FederationExpression> getExpression() {
        return this.expression;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean hasLimit() {
        return this.limit > -1L;
    }

    public List<OrderByField> getOrderByClause() {
        return this.orderByClause;
    }

    public boolean hasNonEmptyOrderByClause() {
        return this.orderByClause != null && this.orderByClause.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constraints that = (Constraints)o;
        return Objects.equal(this.summary, that.summary) && Objects.equal(this.expression, that.expression) && Objects.equal(this.orderByClause, that.orderByClause) && Objects.equal((Object)this.limit, (Object)that.limit);
    }

    public String toString() {
        return "Constraints{summary=" + this.summary + "expression=" + this.expression + "orderByClause=" + this.orderByClause + "limit=" + this.limit + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.summary, this.expression, this.orderByClause, this.limit});
    }

    @Override
    public void close() {
        for (ValueSet next : this.summary.values()) {
            try {
                next.close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

