/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.StringJoiner;

public class OrderByField {
    private final String columnName;
    private final Direction direction;

    @JsonCreator
    public OrderByField(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="direction") Direction direction) {
        this.columnName = columnName;
        this.direction = direction;
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="direction")
    public Direction getDirection() {
        return this.direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderByField that = (OrderByField)o;
        return Objects.equal((Object)this.columnName, (Object)that.columnName) && Objects.equal((Object)((Object)this.direction), (Object)((Object)that.direction));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.columnName, this.direction});
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", OrderByField.class.getSimpleName() + "[", "]");
        return stringJoiner.add("columnName=" + this.columnName).add("direction=" + this.direction.name()).toString();
    }

    public static enum Direction {
        ASC_NULLS_FIRST(true, true),
        ASC_NULLS_LAST(true, false),
        DESC_NULLS_FIRST(false, true),
        DESC_NULLS_LAST(false, false);

        private final boolean ascending;
        private final boolean nullsFirst;

        private Direction(boolean ascending, boolean nullsFirst) {
            this.ascending = ascending;
            this.nullsFirst = nullsFirst;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public boolean isNullsFirst() {
            return this.nullsFirst;
        }

        public String toString() {
            return String.format("%s %s", this.ascending ? "ASC" : "DESC", this.nullsFirst ? "NULLS FIRST" : "NULLS LAST");
        }
    }
}

