/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueMarker;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.beans.Transient;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class Range
implements AutoCloseable {
    private final Marker low;
    private final Marker high;

    @JsonCreator
    public Range(@JsonProperty(value="low") Marker low, @JsonProperty(value="high") Marker high) {
        Objects.requireNonNull(low, "low value is null");
        Objects.requireNonNull(high, "high value is null");
        if (!low.getType().equals(high.getType())) {
            throw new IllegalArgumentException(String.format("Marker types do not match: %s vs %s", low.getType(), high.getType()));
        }
        if (low.getBound() == Marker.Bound.BELOW) {
            throw new IllegalArgumentException("low bound must be EXACTLY or ABOVE");
        }
        if (high.getBound() == Marker.Bound.ABOVE) {
            throw new IllegalArgumentException("high bound must be EXACTLY or BELOW");
        }
        if (low.compareTo(high) > 0) {
            throw new IllegalArgumentException("low must be less than or equal to high");
        }
        this.low = low;
        this.high = high;
    }

    public static Range all(BlockAllocator allocator, ArrowType type) {
        return new Range(Marker.lowerUnbounded(allocator, type), Marker.upperUnbounded(allocator, type));
    }

    public static Range greaterThan(BlockAllocator allocator, ArrowType type, Object low) {
        return new Range(Marker.above(allocator, type, low), Marker.upperUnbounded(allocator, type));
    }

    public static Range greaterThanOrEqual(BlockAllocator allocator, ArrowType type, Object low) {
        return new Range(Marker.exactly(allocator, type, low), Marker.upperUnbounded(allocator, type));
    }

    public static Range lessThan(BlockAllocator allocator, ArrowType type, Object high) {
        return new Range(Marker.lowerUnbounded(allocator, type), Marker.below(allocator, type, high));
    }

    public static Range lessThanOrEqual(BlockAllocator allocator, ArrowType type, Object high) {
        return new Range(Marker.lowerUnbounded(allocator, type), Marker.exactly(allocator, type, high));
    }

    public static Range equal(BlockAllocator allocator, ArrowType type, Object value) {
        return new Range(Marker.exactly(allocator, type, value), Marker.exactly(allocator, type, value));
    }

    public static Range range(BlockAllocator allocator, ArrowType type, Object low, boolean lowInclusive, Object high, boolean highInclusive) {
        Marker lowMarker = lowInclusive ? Marker.exactly(allocator, type, low) : Marker.above(allocator, type, low);
        Marker highMarker = highInclusive ? Marker.exactly(allocator, type, high) : Marker.below(allocator, type, high);
        return new Range(lowMarker, highMarker);
    }

    public ArrowType getType() {
        return this.low.getType();
    }

    @JsonProperty
    public Marker getLow() {
        return this.low;
    }

    @JsonProperty
    public Marker getHigh() {
        return this.high;
    }

    @Transient
    public boolean isSingleValue() {
        return this.low.getBound() == Marker.Bound.EXACTLY && this.low.equals(this.high);
    }

    @Transient
    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("Range does not have just a single value");
        }
        return this.low.getValue();
    }

    @Transient
    public boolean isAll() {
        return this.low.isLowerUnbounded() && this.high.isUpperUnbounded();
    }

    public boolean includes(ValueMarker marker) {
        Objects.requireNonNull(marker, "marker is null");
        return this.low.compareTo(marker) <= 0 && this.high.compareTo(marker) >= 0;
    }

    public boolean contains(Range other) {
        return this.getLow().compareTo(other.getLow()) <= 0 && this.getHigh().compareTo(other.getHigh()) >= 0;
    }

    public Range span(Range other) {
        Marker lowMarker = Marker.min(this.low, other.getLow());
        Marker highMarker = Marker.max(this.high, other.getHigh());
        return new Range(lowMarker, highMarker);
    }

    public boolean overlaps(Range other) {
        return this.getLow().compareTo(other.getHigh()) <= 0 && other.getLow().compareTo(this.getHigh()) <= 0;
    }

    public Range intersect(Range other) {
        if (!this.overlaps(other)) {
            throw new IllegalArgumentException("Cannot intersect non-overlapping ranges");
        }
        Marker lowMarker = Marker.max(this.low, other.getLow());
        Marker highMarker = Marker.min(this.high, other.getHigh());
        return new Range(lowMarker, highMarker);
    }

    public int hashCode() {
        return Objects.hash(this.low, this.high);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("low", (Object)this.low).add("high", (Object)this.high).toString();
    }

    @Override
    public void close() throws Exception {
        this.low.close();
        this.high.close();
    }
}

