/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate.expression;

import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FederationExpression;
import com.amazonaws.athena.connector.lambda.domain.predicate.functions.FunctionName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.arrow.vector.types.pojo.ArrowType;

public final class FunctionCallExpression
extends FederationExpression {
    private final FunctionName functionName;
    private final List<FederationExpression> arguments;

    @JsonCreator
    public FunctionCallExpression(@JsonProperty(value="type") ArrowType type, @JsonProperty(value="functionName") FunctionName functionName, @JsonProperty(value="arguments") List<FederationExpression> arguments) {
        super(type);
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.arguments = new ArrayList<FederationExpression>((Collection)Objects.requireNonNull(arguments, "arguments is null"));
    }

    @JsonProperty(value="functionName")
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @JsonProperty(value="arguments")
    public List<FederationExpression> getArguments() {
        return this.arguments;
    }

    @Override
    @JsonProperty(value="children")
    public List<? extends FederationExpression> getChildren() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionCallExpression call = (FunctionCallExpression)o;
        return Objects.equals(this.functionName, call.functionName) && Objects.equals(this.arguments, call.arguments) && Objects.equals(this.getType(), call.getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.functionName, this.arguments, this.getType());
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", FunctionCallExpression.class.getSimpleName() + "[", "]");
        return stringJoiner.add("functionName=" + this.functionName).add("arguments=" + this.arguments).toString();
    }
}

