/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.records;

import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.records.RecordRequestType;
import com.amazonaws.athena.connector.lambda.records.RecordResponse;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;

public class RemoteReadRecordsResponse
extends RecordResponse {
    private final Schema schema;
    private final List<SpillLocation> remoteBlocks;
    private final EncryptionKey encryptionKey;

    @JsonCreator
    public RemoteReadRecordsResponse(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schema") Schema schema, @JsonProperty(value="remoteBlocks") List<SpillLocation> remoteBlocks, @JsonProperty(value="encryptionKey") EncryptionKey encryptionKey) {
        super(RecordRequestType.READ_RECORDS, catalogName);
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(remoteBlocks, "remoteBlocks is null");
        this.schema = schema;
        this.remoteBlocks = Collections.unmodifiableList(remoteBlocks);
        this.encryptionKey = encryptionKey;
    }

    @JsonProperty
    public Schema getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<SpillLocation> getRemoteBlocks() {
        return this.remoteBlocks;
    }

    @Transient
    public int getNumberBlocks() {
        return this.remoteBlocks.size();
    }

    @JsonProperty
    public EncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schema", (Object)this.schema).add("remoteBlocks", this.remoteBlocks).add("encryptionKey", (Object)"XXXXXX").add("requestType", (Object)this.getRequestType()).add("catalogName", (Object)this.getCatalogName()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteReadRecordsResponse that = (RemoteReadRecordsResponse)o;
        return com.google.common.base.Objects.equal((Object)this.schema, (Object)that.schema) && com.google.common.base.Objects.equal(this.remoteBlocks, that.remoteBlocks) && com.google.common.base.Objects.equal((Object)this.encryptionKey, (Object)that.encryptionKey) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.schema, this.remoteBlocks, this.encryptionKey, this.getRequestType(), this.getCatalogName()});
    }
}

