/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.security;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.arrow.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachableSecretsManager {
    private static final Logger logger = LoggerFactory.getLogger(CachableSecretsManager.class);
    private static final long MAX_CACHE_AGE_MS = 60000L;
    protected static final int MAX_CACHE_SIZE = 10;
    private static final String SECRET_PATTERN = "(\\$\\{[a-zA-Z0-9-_\\-]+\\})";
    private static final String SECRET_NAME_PATTERN = "\\$\\{([a-zA-Z0-9-_\\-]+)\\}";
    private static final Pattern PATTERN = Pattern.compile("(\\$\\{[a-zA-Z0-9-_\\-]+\\})");
    private static final Pattern NAME_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9-_\\-]+)\\}");
    private final LinkedHashMap<String, CacheEntry> cache = new LinkedHashMap();
    private final AWSSecretsManager secretsManager;

    public CachableSecretsManager(AWSSecretsManager secretsManager) {
        this.secretsManager = secretsManager;
    }

    public String resolveSecrets(String rawString) {
        if (rawString == null) {
            return rawString;
        }
        Matcher m = PATTERN.matcher(rawString);
        String result = rawString;
        while (m.find()) {
            String nextSecret = m.group(1);
            Matcher m1 = NAME_PATTERN.matcher(nextSecret);
            m1.find();
            result = result.replace(nextSecret, this.getSecret(m1.group(1)));
        }
        return result;
    }

    public String getSecret(String secretName) {
        CacheEntry cacheEntry = this.cache.get(secretName);
        if (cacheEntry == null || cacheEntry.getAge() > 60000L) {
            logger.info("getSecret: Resolving secret[{}].", (Object)secretName);
            GetSecretValueResult secretValueResult = this.secretsManager.getSecretValue(new GetSecretValueRequest().withSecretId(secretName));
            cacheEntry = new CacheEntry(secretName, secretValueResult.getSecretString());
            this.evictCache(this.cache.size() >= 10);
            this.cache.put(secretName, cacheEntry);
        }
        return cacheEntry.getValue();
    }

    private void evictCache(boolean force) {
        Iterator<Map.Entry<String, CacheEntry>> itr = this.cache.entrySet().iterator();
        int removed = 0;
        while (itr.hasNext()) {
            CacheEntry entry = itr.next().getValue();
            if (entry.getAge() <= 60000L) continue;
            itr.remove();
            ++removed;
        }
        if (removed == 0 && force && (itr = this.cache.entrySet().iterator()).hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    @VisibleForTesting
    protected void addCacheEntry(String name, String value, long createTime) {
        this.cache.put(name, new CacheEntry(name, value, createTime));
    }

    private class CacheEntry {
        private final String name;
        private final String value;
        private final long createTime;

        public CacheEntry(String name, String value) {
            this.value = value;
            this.name = name;
            this.createTime = System.currentTimeMillis();
        }

        public CacheEntry(String name, String value, long createTime) {
            this.value = value;
            this.name = name;
            this.createTime = createTime;
        }

        public String getValue() {
            return this.value;
        }

        public long getAge() {
            return System.currentTimeMillis() - this.createTime;
        }
    }
}

